<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Hash;

class ResetUserPassword extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'user:reset-password';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Reset password for a user';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $email = $this->ask('superadmin@example.com');
        $user = User::where('email', $email)->first();

        if (!$user) {
            $this->error('User not found!');
            return;
        }

        $password = $this->secret('password');
        $confirm = $this->secret('password');

        if ($password !== $confirm) {
            $this->error('Passwords do not match!');
            return;
        }

        $user->password = Hash::make($password);
        $user->save();

        $this->info("Password for $email has been reset successfully!");
    }
}