<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        Commands\MakeSuperAdmin::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * These schedules are run in a single process, immediately after the
     * Artisan command is executed.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule): void
    {
        // $schedule->command('inspire')->hourly();

        // Run daily backup at midnight
        $schedule->command('backup:run full')
                ->daily()
                ->at('00:00')
                ->appendOutputTo(storage_path('logs/backup.log'));

        // Run database-only backup every 6 hours
        $schedule->command('backup:run database')
                ->everySixHours()
                ->appendOutputTo(storage_path('logs/backup.log'));
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
} 