<?php

namespace App\Exports;

use App\Models\MonthlyExpense;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class MonthlyExpensesExport implements FromCollection, WithHeadings, WithMapping
{
    protected $runningBalance = 0;

    public function collection()
    {
        return MonthlyExpense::orderBy('due_date')->get();
    }

    public function map($expense): array
    {
        $this->runningBalance += $expense->credit - $expense->amount_paid;

        return [
            $expense->name,
            $expense->task,
            number_format($expense->amount_paid, 2),
            number_format($expense->credit, 2),
            number_format($this->runningBalance, 2),
            $expense->due_date,
            $expense->notes,
        ];
    }

    public function headings(): array
    {
        return [
            'Name',
            'Task',
            'Amount Paid',
            'Credit',
            'Current Account',
            'Due Date',
            'Notes',
        ];
    }
}

