<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Spatie\Activitylog\Models\Activity;

class LogsExport implements FromCollection, WithHeadings, WithMapping
{
    public function collection()
    {
        return Activity::with('causer')->latest()->get();
    }

    public function headings(): array
    {
        return [
            'Description',
            'User',
            'Subject Type',
            'Subject ID',
            'Date',
            'Properties'
        ];
    }

    public function map($activity): array
    {
        return [
            $activity->description,
            optional($activity->causer)->name ?? 'System',
            class_basename($activity->subject_type),
            $activity->subject_id,
            $activity->created_at->format('Y-m-d H:i:s'),
            json_encode($activity->properties)
        ];
    }
} 