<?php

namespace App\Http\Controllers;

use App\Models\SubAgent;
use Illuminate\Http\Request;

class SubAgentController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'phone' => 'nullable|string|max:20',
            'commission' => 'required|numeric|min:0',
        ]);
        
        SubAgent::create($validated);
        

        SubAgent::create($validated);
        

        return redirect()->back()->with('success', 'Sub-Agent added successfully.');
    }

    public function searchWorkers(Request $request)
{
    $query = Worker::query();

    if ($request->has('sub_agent_id') && $request->sub_agent_id) {
        $query->where('sub_agent_id', $request->sub_agent_id);
    }

    if ($request->has('keyword') && $request->keyword) {
        $keyword = $request->keyword;
        $query->where(function ($q) use ($keyword) {
            $q->where('name', 'like', "%$keyword%")
              ->orWhere('passport_number', 'like', "%$keyword%");
        });
    }

    $workers = $query->get();

    return response()->json($workers);
}

}
