<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Exports\VisitorLogsExport;
use App\Models\VisitorLog;
use App\Models\Visitor;

class VisitorLogExportController extends Controller
{
    /**
     * Display the visitor logs.
     */
    public function index(Request $request)
    {
        $query = VisitorLog::with('visitor');

        // Search filter
        if ($request->has('search')) {
            $search = $request->search;
            $query->whereHas('visitor', function ($q) use ($search) {
                $q->where('name', 'like', "%$search%");
            });
        }

        // Log action filter
        if ($request->has('log_filter') && !empty($request->log_filter)) {
            $query->where('action', $request->log_filter);
        }

        $visitorLogs = $query->latest()->get();

        return view('visitors.index', compact('visitorLogs'));
    }

    /**
     * Export logs to CSV or PDF.
     */
    public function export($format)
    {
        $logs = VisitorLog::with('visitor')->latest()->get();

        if ($format === 'csv') {
            return Excel::download(new VisitorLogsExport($logs), 'visitor_logs.csv');
        } elseif ($format === 'pdf') {
            $pdf = Pdf::loadView('exports.visitor_logs', compact('logs'));
            return $pdf->download('visitor_logs.pdf');
        }

        return redirect()->back()->with('error', 'Invalid export format.');
    }
}
