<?php
// app/Http/Middleware/SuperAdminMiddleware.php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SuperAdminMiddleware
{
    public function handle(Request $request, Closure $next): Response
    {
        if (!auth()->check()) {
            return redirect()->route('login');
        }

        // Debugging output - check the actual role
        \Log::info('SuperAdminMiddleware checking role: ' . auth()->user()->role);
        
        if (!auth()->user()->isSuperAdmin()) {
            abort(403, 'Super Admin access only');
        }

        return $next($request);
    }
}