<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreInvoiceRequest extends FormRequest
{
    public function authorize()
    {
        return true; // Adjust as needed for authorization logic
    }

    public function rules()
    {
        return [
            'workers' => 'required|array|min:1',
            'workers.*' => 'exists:workers,id',
            'stamping_fees' => 'required|array|min:1',
            'stamping_fees.*' => 'numeric|min:0',
            'arrival_fees' => 'required|array|min:1',
            'arrival_fees.*' => 'numeric|min:0',
            'client_name' => 'required|string|max:255',
            'client_email' => 'required|email|max:255',
            'client_phone' => 'required|string|max:15',
            'client_city' => 'required|string|max:255',
            'client_country' => 'required|string|max:255',
            'agency_id' => 'required|exists:agencies,id',
        ];
    }

    public function messages()
    {
        return [
            'workers.required' => 'At least one worker must be selected.',
            'workers.*.exists' => 'Selected worker does not exist.',
            'stamping_fees.required' => 'Stamping fees are required.',
            'stamping_fees.*.numeric' => 'Each stamping fee must be a number.',
            'arrival_fees.required' => 'Arrival fees are required.',
            'arrival_fees.*.numeric' => 'Each arrival fee must be a number.',
            'client_name.required' => 'Client name is required.',
            'client_email.required' => 'Client email is required.',
            'client_phone.required' => 'Client phone number is required.',
            'client_city.required' => 'Client city is required.',
            'client_country.required' => 'Client country is required.',
            'agency_id.required' => 'Agency ID is required.',
        ];
    }
}
