<?php

// app/Models/Application.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Traits\SystemActivityLog;

class Application extends Model
{
    use SystemActivityLog;

    protected $fillable = [
        'job_id', 'user_id', 'cover_letter', 'resume_path', 'status'
    ];

    public function job()
    {
        return $this->belongsTo(Job::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}