<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Traits\SystemActivityLog;

class Employee extends Model
{
    use HasFactory, SystemActivityLog;

    protected $fillable = ['name', 'email', 'phone', 'position', 'hire_date', 'employer_id'];

    public function employer()
    {
        return $this->belongsTo(Employer::class);
    }
}
