<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\Traits\SystemActivityLog;

class JobListing extends Model
{
    use SoftDeletes;
    use HasFactory, SystemActivityLog;

    protected $table = 'job_listings';

    protected $fillable = [
        'title',
        'company',
        'type',
        'location',
        'salary',
        'currency',
        'description',
        'skills',
        'posted',
        'closing_date',
        'urgent',
        'highSalary',
        'commission',
        'status'
    ];

    protected $casts = [
        'skills' => 'array',
        'urgent' => 'boolean',
        'highSalary' => 'boolean',
        'commission' => 'boolean',
        'salary' => 'decimal:2',
        'posted' => 'date',
        'closing_date' => 'date',
    ];

    protected $attributes = [
        'status' => 'active',
        'currency' => 'SAR',
        'urgent' => false,
        'highSalary' => false,
        'commission' => false,
        'posted' => null,
        'closing_date' => null,
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($job) {
            if (empty($job->posted)) {
                $job->posted = now();
            }
        });
    }
    
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}