<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\Traits\SystemActivityLog;

class Payment extends Model
{
    use HasFactory, SystemActivityLog;

    protected $fillable = [
        'invoice_id',
        'amount',
        'payment_method',
        'payment_notes',
        'payment_date',
        'transaction_reference'
    ];

    protected $casts = [
        'payment_date' => 'date',
        'amount' => 'decimal:2'
    ];

    public function invoice(): BelongsTo
    {
        return $this->belongsTo(Invoice::class);
    }
} 