<?php

namespace App\Models\Traits;

use App\Models\Activity;

trait SystemActivityLog
{
    public static function bootSystemActivityLog()
    {
        static::created(function ($model) {
            $model->logSystemActivity('created');
        });

        static::updated(function ($model) {
            $model->logSystemActivity('updated');
        });

        static::deleted(function ($model) {
            $model->logSystemActivity('deleted');
        });
    }

    public function systemActivities()
    {
        return $this->morphMany(Activity::class, 'subject');
    }

    public function logSystemActivity($action)
    {
        $description = sprintf(
            '%s %s %s',
            auth()->user() ? auth()->user()->name : 'System',
            $action,
            class_basename($this)
        );

        Activity::create([
            'description' => $description,
            'causer_type' => auth()->user() ? get_class(auth()->user()) : null,
            'causer_id' => auth()->user() ? auth()->id() : null,
            'subject_type' => get_class($this),
            'subject_id' => $this->id,
            'properties' => [
                'old' => $this->getOriginal(),
                'attributes' => $this->getAttributes()
            ]
        ]);
    }

    public function logUserAction($action, $description = null)
    {
        $description = $description ?? sprintf(
            '%s %s',
            auth()->user() ? auth()->user()->name : 'System',
            $action
        );

        Activity::create([
            'description' => $description,
            'causer_type' => auth()->user() ? get_class(auth()->user()) : null,
            'causer_id' => auth()->user() ? auth()->id() : null,
            'subject_type' => get_class($this),
            'subject_id' => $this->id,
            'properties' => [
                'action' => $action,
                'attributes' => $this->getAttributes()
            ]
        ]);
    }
} 