<?php

namespace Database\Factories;

use App\Models\JobListing;
use Illuminate\Database\Eloquent\Factories\Factory;

class JobListingFactory extends Factory
{
    protected $model = JobListing::class;

    public function definition()
    {
        $jobTypes = ['Full-time', 'Part-time', 'Contract', 'Temporary', 'Internship'];
        $locations = ['Dubai', 'Abu Dhabi', 'Riyadh', 'Jeddah', 'Doha', 'Kuwait City', 'Muscat'];
        $companies = [
            'Gulf Tech Solutions', 'Arabian Business Group', 'Middle East Enterprises',
            'Desert Digital', 'Gulf Innovations', 'Arabian Ventures', 'Desert Dynamics',
            'Gulf Global Services', 'Arabian Tech Hub', 'Middle East Solutions'
        ];
        
        $skills = [
            'PHP', 'Laravel', 'JavaScript', 'Vue.js', 'React', 'Node.js', 'Python',
            'Java', 'C#', 'SQL', 'MongoDB', 'AWS', 'Docker', 'Kubernetes',
            'Project Management', 'Agile', 'Scrum', 'DevOps', 'UI/UX Design',
            'Digital Marketing', 'Sales', 'Customer Service', 'Administration',
            'Finance', 'Accounting', 'HR', 'Operations', 'Supply Chain'
        ];

        $salaryRanges = [
            'Full-time' => [5000, 25000],
            'Part-time' => [2000, 8000],
            'Contract' => [300, 500],
            'Temporary' => [2000, 10000],
            'Internship' => [1000, 3000]
        ];

        $type = $this->faker->randomElement($jobTypes);
        $salaryRange = $salaryRanges[$type];
        $salary = $this->faker->numberBetween($salaryRange[0], $salaryRange[1]);
        
        $currency = $this->faker->boolean(70) ? 'SAR' : 'AED';
        
        $posted = $this->faker->dateTimeBetween('-30 days', 'now');
        $closing_date = $this->faker->dateTimeBetween($posted, '+60 days');

        return [
            'title' => $this->faker->jobTitle,
            'type' => $type,
            'company' => $this->faker->randomElement($companies),
            'location' => $this->faker->randomElement($locations),
            'salary' => $salary,
            'currency' => $currency,
            'posted' => $posted,
            'closing_date' => $closing_date,
            'description' => $this->faker->paragraphs(3, true),
            'skills' => json_encode($this->faker->randomElements($skills, $this->faker->numberBetween(3, 6))),
            'urgent' => $this->faker->boolean(20),
            'highSalary' => $salary > 15000,
            'commission' => $this->faker->boolean(30),
            'status' => 'active',
            'user_id' => 1 // Default to admin user
        ];
    }
}
