<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('job_listings', function (Blueprint $table) {
            // Make sure all date fields are nullable
            $table->date('posted')->nullable()->change();
            $table->date('closing_date')->nullable()->change();
            
            // Make sure boolean fields have default values
            $table->boolean('urgent')->default(false)->change();
            $table->boolean('highSalary')->default(false)->change();
            $table->boolean('commission')->default(false)->change();
            
            // Make sure string fields have appropriate lengths
            $table->string('title', 255)->change();
            $table->string('company', 255)->change();
            $table->string('type', 255)->change();
            $table->string('location', 255)->change();
            $table->string('currency', 10)->default('SAR')->change();
            $table->string('status', 255)->default('active')->change();
            
            // Make sure numeric fields have appropriate types
            $table->decimal('salary', 10, 2)->nullable()->change();
            
            // Make sure JSON fields are properly typed
            $table->json('skills')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('job_listings', function (Blueprint $table) {
            // Revert changes if needed
            $table->date('posted')->nullable(false)->change();
            $table->date('closing_date')->nullable(false)->change();
            $table->boolean('urgent')->default(null)->change();
            $table->boolean('highSalary')->default(null)->change();
            $table->boolean('commission')->default(null)->change();
            $table->string('title')->change();
            $table->string('company')->change();
            $table->string('type')->change();
            $table->string('location')->change();
            $table->string('currency')->change();
            $table->string('status')->change();
            $table->decimal('salary', 10, 2)->nullable(false)->change();
            $table->json('skills')->nullable(false)->change();
        });
    }
};
