<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('job_listings', function (Blueprint $table) {
            // Drop the closing_date column
            $table->dropColumn('closing_date');
        });

        Schema::table('job_listings', function (Blueprint $table) {
            // Recreate the closing_date column as nullable
            $table->date('closing_date')->nullable()->after('posted');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('job_listings', function (Blueprint $table) {
            // Drop the closing_date column
            $table->dropColumn('closing_date');
        });

        Schema::table('job_listings', function (Blueprint $table) {
            // Recreate the closing_date column as non-nullable
            $table->date('closing_date')->after('posted');
        });
    }
};
