<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class ExternalAgenciesTableSeeder extends Seeder
{
    public function run(): void
    {
        $agencies = [
            [
                'company_name' => 'Al-Riyadh Recruitment Services',
                'responsible_name' => 'Ahmed Al-Saud',
                'email' => 'contact@alriyadhrecruitment.com',
                'phone' => '+966112345678',
                'city' => 'Riyadh',
                'country' => 'Saudi Arabia',
                'license_number' => 'SA-2023-001',
                'license_date' => '2023-01-01',
                'recruitment_fee' => 5000.00,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'company_name' => 'Jeddah International Manpower',
                'responsible_name' => 'Mohammed Al-Jeddawi',
                'email' => 'info@jeddahmanpower.com',
                'phone' => '+966126789012',
                'city' => 'Jeddah',
                'country' => 'Saudi Arabia',
                'license_number' => 'SA-2023-002',
                'license_date' => '2023-01-01',
                'recruitment_fee' => 4500.00,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'company_name' => 'Dammam Global Recruitment',
                'responsible_name' => 'Sultan Al-Dammami',
                'email' => 'hr@dammamglobal.com',
                'phone' => '+966133456789',
                'city' => 'Dammam',
                'country' => 'Saudi Arabia',
                'license_number' => 'SA-2023-003',
                'license_date' => '2023-01-01',
                'recruitment_fee' => 4800.00,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        DB::table('external_agencies')->insert($agencies);
    }
} 