<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Carbon\Carbon;

class InvoiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        for ($i = 1; $i <= 10; $i++) {
            $invoiceDate = Carbon::now()->subDays(rand(1, 30));
            $dueDate = $invoiceDate->copy()->addDays(rand(10, 20));

            DB::table('invoices')->insert([
                'invoice_number' => 'INV-' . Str::random(5),
                'invoice_date' => $invoiceDate,
                'due_date' => $dueDate,
                'client_name' => 'Client ' . $i,
                'client_email' => 'client' . $i . '@example.com',
                'client_phone' => '07' . rand(10000000, 99999999),
                'client_address' => '123 Street, City, Country',
                'worker_name' => 'Worker ' . $i,
                'passport_number' => strtoupper(Str::random(8)),
                'nationality' => 'Country ' . $i,
                'recruitment_fee' => rand(1000, 5000),
                'subtotal' => rand(5000, 10000),
                'tax_amount' => rand(100, 500),
                'total_amount' => rand(6000, 12000),
                'amount_paid' => rand(1000, 6000),
                'balance_due' => rand(0, 6000),
                'payment_method' => ['Cash', 'Bank Transfer', 'Credit Card'][array_rand(['Cash', 'Bank Transfer', 'Credit Card'])],
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
