<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingsSeeder extends Seeder
{
    public function run()
    {
        $settings = [
            // General Settings
            ['key' => 'site_name', 'value' => 'HireStream', 'type' => 'string', 'group' => 'general'],
            ['key' => 'site_description', 'value' => 'HireStream - Your Hiring Solution', 'type' => 'string', 'group' => 'general'],
            
            // Backup Settings
            ['key' => 'backup_frequency', 'value' => 'daily', 'type' => 'string', 'group' => 'backup'],
            ['key' => 'backup_retention', 'value' => '30', 'type' => 'integer', 'group' => 'backup'],
            
            // Notification Settings
            ['key' => 'email_notifications', 'value' => 'enabled', 'type' => 'string', 'group' => 'notifications'],
            ['key' => 'notification_email', 'value' => 'admin@example.com', 'type' => 'string', 'group' => 'notifications'],
            
            // Security Settings
            ['key' => 'session_timeout', 'value' => '30', 'type' => 'integer', 'group' => 'security'],
            ['key' => 'max_login_attempts', 'value' => '5', 'type' => 'integer', 'group' => 'security'],
        ];

        foreach ($settings as $setting) {
            Setting::set($setting['key'], $setting['value'], $setting['type'], $setting['group']);
        }
    }
} 