<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UsersTableSeeder extends Seeder
{
    public function run()
    {
        // Clear existing users (only in development)
        if (app()->environment('local')) {
            User::truncate();
        }

        // Create Super Admin
        User::create([
            'name' => 'Super Admin',
            'email' => 'superadmin@example.com',
            'password' => Hash::make('password123'), // Use a strong password in production
            'role' => User::ROLE_SUPER_ADMIN,
            'email_verified_at' => now(),
        ]);

        // Create Admin
        User::create([
            'name' => 'Admin User',
            'email' => 'admin@example.com',
            'password' => Hash::make('password123'),
            'role' => User::ROLE_ADMIN,
            'email_verified_at' => now(),
        ]);

        // Create Regular User
        User::create([
            'name' => 'Regular User',
            'email' => 'user@example.com',
            'password' => Hash::make('password123'),
            'role' => User::ROLE_USER,
            'email_verified_at' => now(),
        ]);

        // Optional: Create additional test users
        if (app()->environment('local')) {
            User::create([
                'name' => 'Test Super Admin',
                'email' => 'test.superadmin@example.com',
                'password' => Hash::make('password123'),
                'role' => User::ROLE_SUPER_ADMIN,
            ]);

            User::create([
                'name' => 'Test Admin',
                'email' => 'test.admin@example.com',
                'password' => Hash::make('password123'),
                'role' => User::ROLE_ADMIN,
            ]);

            User::create([
                'name' => 'Test User',
                'email' => 'test.user@example.com',
                'password' => Hash::make('password123'),
                'role' => User::ROLE_USER,
            ]);
        }
    }
}