<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class WorkersTableSeeder extends Seeder
{
    public function run(): void
    {
        $timestamp = time();
        $workers = [
            [
                'surname' => 'Kamau',
                'given_names' => 'John Mwangi',
                'date_of_birth' => '1990-05-15',
                'gender' => 'Male',
                'marital_status' => 'Married',
                'religion' => 'Christian',
                'occupation' => 'Construction Worker',
                'education_level' => 'High School',
                'skills' => 'Heavy Equipment Operation, Construction Safety',
                'languages' => 'English, Swahili',
                'id_number' => '12345678' . $timestamp,
                'mobile_number' => '+254712345678',
                'number_of_children' => 2,
                'email' => "john.kamau.{$timestamp}@example.com",
                'work_experience' => '5 years in construction',
                'passport_number' => 'A12345678' . $timestamp,
                'passport_issue_place' => 'Nairobi',
                'passport_issue_date' => '2020-01-01',
                'passport_expiry_date' => '2030-01-01',
                'country' => 'Kenya',
                'city' => 'Nairobi',
                'place_of_birth' => 'Nairobi',
                'relative_name' => 'Mary Kamau',
                'relative_kinship' => 'Wife',
                'relative_phone' => '+254723456789',
                'relative_address' => '123 Main Street, Nairobi',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'surname' => 'Ochieng',
                'given_names' => 'Sarah Achieng',
                'date_of_birth' => '1988-08-20',
                'gender' => 'Female',
                'marital_status' => 'Single',
                'religion' => 'Christian',
                'occupation' => 'Housekeeper',
                'education_level' => 'Secondary',
                'skills' => 'Housekeeping, Cooking',
                'languages' => 'English, Swahili, Luo',
                'id_number' => '23456789' . $timestamp,
                'mobile_number' => '+254723456789',
                'number_of_children' => 0,
                'email' => "sarah.ochieng.{$timestamp}@example.com",
                'work_experience' => '3 years in hospitality',
                'passport_number' => 'B23456789' . $timestamp,
                'passport_issue_place' => 'Kisumu',
                'passport_issue_date' => '2021-02-01',
                'passport_expiry_date' => '2031-02-01',
                'country' => 'Kenya',
                'city' => 'Kisumu',
                'place_of_birth' => 'Kisumu',
                'relative_name' => 'James Ochieng',
                'relative_kinship' => 'Brother',
                'relative_phone' => '+254734567890',
                'relative_address' => '456 Lake Road, Kisumu',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'surname' => 'Mutua',
                'given_names' => 'Peter Musyoki',
                'date_of_birth' => '1992-03-10',
                'gender' => 'Male',
                'marital_status' => 'Married',
                'religion' => 'Christian',
                'occupation' => 'Driver',
                'education_level' => 'Secondary',
                'skills' => 'Heavy Vehicle Operation, Defensive Driving',
                'languages' => 'English, Swahili, Kamba',
                'id_number' => '34567890' . $timestamp,
                'mobile_number' => '+254734567890',
                'number_of_children' => 1,
                'email' => "peter.mutua.{$timestamp}@example.com",
                'work_experience' => '4 years as professional driver',
                'passport_number' => 'C34567890' . $timestamp,
                'passport_issue_place' => 'Machakos',
                'passport_issue_date' => '2022-03-01',
                'passport_expiry_date' => '2032-03-01',
                'country' => 'Kenya',
                'city' => 'Machakos',
                'place_of_birth' => 'Machakos',
                'relative_name' => 'Jane Mutua',
                'relative_kinship' => 'Wife',
                'relative_phone' => '+254745678901',
                'relative_address' => '789 Market Street, Machakos',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'surname' => 'Wanjiku',
                'given_names' => 'Grace Muthoni',
                'date_of_birth' => '1995-11-25',
                'gender' => 'Female',
                'marital_status' => 'Single',
                'religion' => 'Christian',
                'occupation' => 'Caregiver',
                'education_level' => 'College',
                'skills' => 'Patient Care, First Aid',
                'languages' => 'English, Swahili, Kikuyu',
                'id_number' => '45678901' . $timestamp,
                'mobile_number' => '+254745678901',
                'number_of_children' => 0,
                'email' => "grace.wanjiku.{$timestamp}@example.com",
                'work_experience' => '2 years in elderly care',
                'passport_number' => 'D45678901' . $timestamp,
                'passport_issue_place' => 'Nyeri',
                'passport_issue_date' => '2023-01-01',
                'passport_expiry_date' => '2033-01-01',
                'country' => 'Kenya',
                'city' => 'Nyeri',
                'place_of_birth' => 'Nyeri',
                'relative_name' => 'David Wanjiku',
                'relative_kinship' => 'Father',
                'relative_phone' => '+254756789012',
                'relative_address' => '321 Mountain View, Nyeri',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'surname' => 'Omondi',
                'given_names' => 'James Odhiambo',
                'date_of_birth' => '1985-07-30',
                'gender' => 'Male',
                'marital_status' => 'Married',
                'religion' => 'Christian',
                'occupation' => 'Security Guard',
                'education_level' => 'Secondary',
                'skills' => 'Security Operations, First Aid',
                'languages' => 'English, Swahili, Luo',
                'id_number' => '56789012' . $timestamp,
                'mobile_number' => '+254756789012',
                'number_of_children' => 3,
                'email' => "james.omondi.{$timestamp}@example.com",
                'work_experience' => '8 years in security',
                'passport_number' => 'E56789012' . $timestamp,
                'passport_issue_place' => 'Kisumu',
                'passport_issue_date' => '2021-06-01',
                'passport_expiry_date' => '2031-06-01',
                'country' => 'Kenya',
                'city' => 'Kisumu',
                'place_of_birth' => 'Kisumu',
                'relative_name' => 'Susan Omondi',
                'relative_kinship' => 'Wife',
                'relative_phone' => '+254767890123',
                'relative_address' => '654 Lake View, Kisumu',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        foreach ($workers as $worker) {
            DB::table('workers')->insert($worker);
        }
    }
}