# Truehost Deployment Checklist

## Pre-Deployment
- [ ] Backup current database
- [ ] Backup current files
- [ ] Update all dependencies
- [ ] Run tests
- [ ] Clear all caches locally

## File Preparation
- [ ] Remove development files (.git, .env.example, etc.)
- [ ] Remove node_modules directory
- [ ] Remove storage/logs/*
- [ ] Remove storage/framework/cache/*
- [ ] Remove storage/framework/sessions/*
- [ ] Remove storage/framework/views/*
- [ ] Compress the application

## Server Setup
- [ ] Create database in cPanel
- [ ] Create database user
- [ ] Set up SSL certificate
- [ ] Configure domain DNS

## File Upload
- [ ] Upload compressed files
- [ ] Extract in public_html
- [ ] Set proper file permissions:
  ```bash
  find . -type f -exec chmod 644 {} \;
  find . -type d -exec chmod 755 {} \;
  chmod -R 775 storage
  chmod -R 775 bootstrap/cache
  ```

## Configuration
- [ ] Upload production .env file
- [ ] Generate new application key
- [ ] Configure database credentials
- [ ] Configure mail settings
- [ ] Set up SSL/HTTPS

## Post-Deployment
- [ ] Run migrations
- [ ] Clear all caches
- [ ] Test all features
- [ ] Monitor error logs
- [ ] Set up backup schedule

## Security Checks
- [ ] Verify .env file is not accessible
- [ ] Check file permissions
- [ ] Verify SSL is working
- [ ] Test login functionality
- [ ] Check error reporting is disabled

## Performance
- [ ] Enable caching
- [ ] Optimize images
- [ ] Minify CSS/JS
- [ ] Enable compression
- [ ] Set up CDN (if needed)

## Monitoring
- [ ] Set up error logging
- [ ] Configure backup system
- [ ] Set up uptime monitoring
- [ ] Configure security scanning

## Documentation
- [ ] Update deployment documentation
- [ ] Document server configuration
- [ ] Create maintenance procedures
- [ ] Document backup/restore process 