@extends('layouts.app')

@section('content')
    <x-jobs-nav />
    
    <div class="container py-4">
        <div class="card">
            <div class="card-header">
                <h2 class="h5 mb-0">Apply for: {{ $job->title }}</h2>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('applications.store', $job) }}" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="mb-3">
                        <label for="cover_letter" class="form-label">Cover Letter</label>
                        <textarea class="form-control" id="cover_letter" name="cover_letter" rows="6" required></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label for="resume" class="form-label">Resume (PDF or DOC)</label>
                        <input type="file" class="form-control" id="resume" name="resume" accept=".pdf,.doc,.docx" required>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">Submit Application</button>
                </form>
            </div>
        </div>
    </div>
@endsection