<!-- resources/views/components/jobs-nav.blade.php -->
<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4">
    <div class="container">
        <a class="navbar-brand fw-bold" href="{{ route('jobs.index') }}">Jobs Board</a>
        
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#jobsNavbar">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <div class="collapse navbar-collapse" id="jobsNavbar">
            <ul class="navbar-nav me-auto">
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('jobs.index') ? 'active' : '' }}" 
                       href="{{ route('jobs.index') }}">All Jobs</a>
                </li>
                
                @auth
                    @if(auth()->user()->isAdmin())
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('jobs.create') ? 'active' : '' }}" 
                               href="{{ route('jobs.create') }}">Post Job</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('applications.index') ? 'active' : '' }}" 
                               href="{{ route('applications.index') }}">Applications</a>
                        </li>
                    @endif
                @endauth
            </ul>
        </div>
    </div>
</nav>