<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                Edit Employment Request
            </h2>
          
           
        </div>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

            {{-- SUCCESS Message --}}
            @if (session('success'))
                <div class="alert alert-success">
                    <h5><i class="fas fa-check-circle"></i> {{ session('success.title') ?? 'Success' }}</h5>
                    <p>{{ session('success.content') ?? session('success') }}</p>
                </div>
            @endif

            {{-- ERROR Validation --}}
            @if ($errors->any())
                <div class="alert alert-danger">
                    <h5><i class="fas fa-exclamation-triangle"></i> Please fix the following errors:</h5>
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="card shadow-sm">
            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                <div>
                    Editing Contract for: 
                    <strong>{{ $employmentRequest->worker->surname }} {{ $employmentRequest->worker->given_names }}</strong>
                </div>
                <a href="{{ route('employment_status.index') }}" class="text-blue hover:text-blue-200">
                    <i class="fas fa-arrow-left"></i> Back to List
                </a>
            </div>

                
                <div class="card-body">
                    <form method="POST" action="{{ route('employment_status.update', $employmentRequest->id) }}">
                        @csrf
                        @method('PUT')

                        <div class="row g-3">
                            {{-- Contract Number --}}
                            <div class="col-md-6">
                                <label for="contract_number" class="form-label">Contract Number</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-file-earmark-text"></i></span>
                                    <input type="text" name="contract_number" class="form-control @error('contract_number') is-invalid @enderror"
                                        value="{{ old('contract_number', $employmentRequest->contract_number) }}" readonly>
                                </div>
                                @error('contract_number')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>

                            {{-- Visa Number --}}
                            <div class="col-md-6">
                                <label for="visa_number" class="form-label">Visa Number</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-file-earmark-person"></i></span>
                                    <input type="text" name="visa_number" class="form-control @error('visa_number') is-invalid @enderror"
                                        value="{{ old('visa_number', $employmentRequest->visa_number) }}" required>
                                </div>
                                @error('visa_number')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>

                            {{-- Occupation --}}
                            <div class="col-md-6">
                                <label class="form-label">Occupation</label>
                                <input type="text" class="form-control" value="{{ $employmentRequest->worker->occupation }}" readonly>
                            </div>

                            {{-- e_Agency Assignment --}}
                            <div class="col-md-6">
                                <label for="external_agency_id" class="form-label">Assign e_Agency</label>
                                <select name="external_agency_id" class="form-select @error('external_agency_id') is-invalid @enderror" required>
                                    <option value="">Select a e_Agency</option>
                                    @foreach ($external_agencies as $agency)
                                        <option value="{{ $agency->id }}"
                                            {{ old('external_agency_id', $employmentRequest->external_agency_id) == $agency->id ? 'selected' : '' }}>
                                            {{ $agency->company_name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('external_agency_id')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>

                            {{-- Status --}}
                            <div class="col-md-6">
                                <label for="status" class="form-label">Status</label>
                                <select name="status" class="form-select @error('status') is-invalid @enderror" required>
                                    @foreach ([
                                        'Pending', 'Sent NEA', 'NEA Approved', 'Medical Fit',
                                        'Ready for Submission', 'Submitted Embassy', 'Visa Issued', 'Travelled'
                                    ] as $status)
                                        <option value="{{ $status }}" {{ old('status', $employmentRequest->status) == $status ? 'selected' : '' }}>
                                            {{ $status }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('status')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>

                            {{-- Payment Status --}}
                            <div class="col-md-6">
                                <label for="payment_status" class="form-label">Payment Status</label>
                                <select name="payment_status" class="form-select @error('payment_status') is-invalid @enderror" required>
                                    <option value="Pending" {{ old('payment_status', $employmentRequest->payment_status) == 'Pending' ? 'selected' : '' }}>Pending</option>
                                    <option value="Paid" {{ old('payment_status', $employmentRequest->payment_status) == 'Paid' ? 'selected' : '' }}>Paid</option>
                                </select>
                                @error('payment_status')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update
                            </button>
                            <a href="{{ route('employment_status.index') }}" class="btn btn-outline-secondary">
                                <i class="fas fa-times"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
