@extends('layouts.invoices')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header">
            <h2>Edit Invoice #{{ $invoice->invoice_number }}</h2>
        </div>
        <div class="card-body">
            <form action="{{ route('invoices.update', $invoice->id) }}" method="POST">
                @csrf
                @method('PUT')

                <!-- Invoice Details -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="invoice_date" class="form-label">Invoice Date</label>
                            <input type="date" class="form-control" id="invoice_date" name="invoice_date" 
                                   value="{{ old('invoice_date', $invoice->invoice_date->format('Y-m-d')) }}" required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="external_agency_id" class="form-label">Agency</label>
                            <select class="form-select" id="external_agency_id" name="external_agency_id" required>
                                @foreach($agencies as $agency)
                                    <option value="{{ $agency->id }}" 
                                        {{ $invoice->external_agency_id == $agency->id ? 'selected' : '' }}>
                                        {{ $agency->company_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-select" id="status" name="status" required>
                                <option value="draft" {{ $invoice->status == 'draft' ? 'selected' : '' }}>Draft</option>
                                <option value="sent" {{ $invoice->status == 'sent' ? 'selected' : '' }}>Sent</option>
                                <option value="paid" {{ $invoice->status == 'paid' ? 'selected' : '' }}>Paid</option>
                                <option value="overdue" {{ $invoice->status == 'overdue' ? 'selected' : '' }}>Overdue</option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Billing Information -->
                <h5 class="fw-bold mb-3">Billing Information</h5>
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="client_name" class="form-label">Client Name</label>
                            <input type="text" class="form-control" id="client_name" name="client_name" 
                                   value="{{ old('client_name', $invoice->client_name) }}" required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="client_email" class="form-label">Client Email</label>
                            <input type="email" class="form-control" id="client_email" name="client_email" 
                                   value="{{ old('client_email', $invoice->client_email) }}">
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="client_phone" class="form-label">Client Phone</label>
                            <input type="text" class="form-control" id="client_phone" name="client_phone" 
                                   value="{{ old('client_phone', $invoice->client_phone) }}">
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="client_city" class="form-label">City</label>
                                    <input type="text" class="form-control" id="client_city" name="client_city" 
                                           value="{{ old('client_city', $invoice->client_city) }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="client_country" class="form-label">Country</label>
                                    <input type="text" class="form-control" id="client_country" name="client_country" 
                                           value="{{ old('client_country', $invoice->client_country) }}" required>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Workers and Fees -->
                <h5 class="fw-bold mb-3">Workers and Fees</h5>
                <div class="table-responsive mb-4">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Worker Name</th>
                                <th>Passport Number</th>
                                <th>Stamping Fee</th>
                                <th>Arrival Fee</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($workers as $index => $worker)
                                <tr>
                                    <td>
                                        <input type="hidden" name="workers[{{ $index }}][worker_id]" value="{{ $worker['worker_id'] }}">
                                        <input type="hidden" name="workers[{{ $index }}][worker_name]" value="{{ $worker['worker_name'] }}">
                                        {{ $worker['worker_name'] }}
                                    </td>
                                    <td>
                                        <input type="hidden" name="workers[{{ $index }}][passport_number]" value="{{ $worker['passport_number'] }}">
                                        {{ $worker['passport_number'] }}
                                    </td>
                                    <td>
                                        <input type="number" class="form-control" name="workers[{{ $index }}][stamping_fee]" 
                                            value="{{ old('workers.'.$index.'.stamping_fee', $worker['stamping_fee']) }}" step="0.01" min="0" required>
                                    </td>
                                    <td>
                                        <input type="number" class="form-control" name="workers[{{ $index }}][arrival_fee]" 
                                            value="{{ old('workers.'.$index.'.arrival_fee', $worker['arrival_fee']) }}" step="0.01" min="0" required>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="2" class="text-end">Total</th>
                                <th>{{ number_format(array_sum(array_column($workers, 'stamping_fee')), 2) }}</th>
                                <th>{{ number_format(array_sum(array_column($workers, 'arrival_fee')), 2) }}</th>
                            </tr>
                            <tr class="table-active">
                                <th colspan="3" class="text-end">Grand Total</th>
                                <th>{{ number_format($invoice->total_amount, 2) }}</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="d-flex justify-content-between">
                    <a href="{{ route('invoices.show', $invoice->id) }}" class="btn btn-secondary">Cancel</a>
                    <button type="submit" class="btn btn-primary">Update Invoice</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection