@extends('layouts.invoices')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <ul class="nav nav-tabs">
        <li class="nav-item">
                    <a class="nav-link {{ $activeTab === 'invoices' ? 'active' : '' }}" 
                       href="#invoices" data-bs-toggle="tab">
                        <i class="fas fa-file-invoice"></i> Invoices
                    </a>
        </li>
        <li class="nav-item">
                    <a class="nav-link {{ $activeTab === 'vouchers' ? 'active' : '' }}" 
                       href="#vouchers" data-bs-toggle="tab">
                        <i class="fas fa-receipt"></i> Payment Vouchers
                    </a>
        </li>
        <li class="nav-item">
                    <a class="nav-link {{ $activeTab === 'expenses' ? 'active' : '' }}" 
                       href="#expenses" data-bs-toggle="tab">
                        <i class="fas fa-wallet"></i> Monthly Expenses
                    </a>
        </li>
    </ul>

            <div class="tab-content mt-4">
                @include('invoices.partials.tabs.invoices-tab')
                @include('invoices.partials.tabs.vouchers-tab')
                <x-invoices.expenses-tab :expenses="$expenses" :activeTab="$activeTab" />
            </div>
        </div>
    </div>
</div>

@include('invoices.partials.modals.create-invoice-modal')
@include('invoices.partials.modals.create-voucher-modal')
@include('invoices.partials.modals.create-expense-modal')

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Bootstrap tabs
    var triggerTabList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tab"]'));
    triggerTabList.forEach(function(triggerEl) {
        var tabTrigger = new bootstrap.Tab(triggerEl);
        triggerEl.addEventListener('click', function(event) {
            event.preventDefault();
            tabTrigger.show();
        });
    });

    // Show active tab based on URL parameter
    const urlParams = new URLSearchParams(window.location.search);
    const activeTab = urlParams.get('tab');
    if (activeTab) {
        const tabElement = document.querySelector(`[href="#${activeTab}"]`);
        if (tabElement) {
            new bootstrap.Tab(tabElement).show();
        }
    }

    // Delete functions
    window.deleteInvoice = function(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: 'You will not be able to recover this invoice!',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!',
            width: 'auto',
            padding: '0.5em',
            customClass: {
                popup: 'colored-toast'
            }
        }).then((result) => {
            if (result.isConfirmed) {
                fetch(`/invoices/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        'Accept': 'application/json',
                        'Content-Type': 'application/json'
                    },
                    credentials: 'same-origin'
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok');
                    }
                    return response.json();
                })
                .then(data => {
                    if (data.success) {
                        const Toast = Swal.mixin({
                            toast: true,
                            position: 'center',
                            showConfirmButton: false,
                            timer: 3000,
                            timerProgressBar: true,
                            width: 'auto',
                            padding: '0.5em',
                            customClass: {
                                popup: 'colored-toast'
                            }
                        });

                        Toast.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: 'Invoice deleted successfully!'
                        }).then(() => {
                            window.location.reload();
                        });
                    } else {
                        throw new Error(data.message || 'Error deleting invoice');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    const ErrorAlert = Swal.mixin({
                        toast: true,
                        position: 'center',
                        showConfirmButton: true,
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'OK',
                        icon: 'error',
                        width: 'auto',
                        padding: '0.5em',
                        customClass: {
                            popup: 'colored-toast'
                        }
                    });

                    ErrorAlert.fire({
                        title: 'Error',
                        text: error.message || 'Error deleting invoice'
                    });
                });
            }
        });
    };

    window.deleteVoucher = function(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: 'You will not be able to recover this voucher!',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!',
            width: 'auto',
            padding: '0.5em',
            customClass: {
                popup: 'colored-toast'
            }
        }).then((result) => {
            if (result.isConfirmed) {
                fetch(`/vouchers/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const Toast = Swal.mixin({
                            toast: true,
                            position: 'center',
                            showConfirmButton: false,
                            timer: 3000,
                            timerProgressBar: true,
                            width: 'auto',
                            padding: '0.5em',
                            customClass: {
                                popup: 'colored-toast'
                            }
                        });

                        Toast.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: 'Voucher deleted successfully!'
                        }).then(() => {
                            window.location.reload();
                        });
                    } else {
                        const ErrorAlert = Swal.mixin({
                            toast: true,
                            position: 'center',
                            showConfirmButton: true,
                            confirmButtonColor: '#3085d6',
                            confirmButtonText: 'OK',
                            icon: 'error',
                            width: 'auto',
                            padding: '0.5em',
                            customClass: {
                                popup: 'colored-toast'
                            }
                        });

                        ErrorAlert.fire({
                            title: 'Error',
                            text: 'Error deleting voucher'
                        });
                    }
                });
            }
        });
    };

    window.deleteExpense = function(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: 'You will not be able to recover this expense!',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!',
            width: 'auto',
            padding: '0.5em',
            customClass: {
                popup: 'colored-toast'
            }
        }).then((result) => {
            if (result.isConfirmed) {
                fetch(`/monthly-expenses/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const Toast = Swal.mixin({
                            toast: true,
                            position: 'center',
                            showConfirmButton: false,
                            timer: 3000,
                            timerProgressBar: true,
                            width: 'auto',
                            padding: '0.5em',
                            customClass: {
                                popup: 'colored-toast'
                            }
                        });

                        Toast.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: 'Expense deleted successfully!'
                        }).then(() => {
                            window.location.reload();
                        });
                    } else {
                        const ErrorAlert = Swal.mixin({
                            toast: true,
                            position: 'center',
                            showConfirmButton: true,
                            confirmButtonColor: '#3085d6',
                            confirmButtonText: 'OK',
                            icon: 'error',
                            width: 'auto',
                            padding: '0.5em',
                            customClass: {
                                popup: 'colored-toast'
                            }
                        });

                        ErrorAlert.fire({
                            title: 'Error',
                            text: 'Error deleting expense'
                        });
                    }
                });
            }
        });
    };
});

// Add custom styles for smaller popups
const style = document.createElement('style');
style.textContent = `
    .colored-toast {
        font-size: 0.9em !important;
        min-width: 200px !important;
        max-width: 400px !important;
    }
    .colored-toast .swal2-title {
        font-size: 1.1em !important;
        margin: 0.5em !important;
    }
    .colored-toast .swal2-html-container {
        font-size: 0.9em !important;
        margin: 0.5em !important;
    }
    .colored-toast .swal2-confirm {
        padding: 0.3em 1em !important;
        font-size: 0.9em !important;
    }
`;
document.head.appendChild(style);
</script>
@endpush

@push('styles')
<style>
.nav-tabs .nav-link {
    color: #6c757d;
    border: none;
    border-bottom: 2px solid transparent;
    padding: 0.5rem 1rem;
    margin-right: 0.5rem;
}

.nav-tabs .nav-link.active {
    color: #0d6efd;
    border-bottom: 2px solid #0d6efd;
    background: none;
}

.tab-content {
    padding: 1rem 0;
}

.table th {
    background-color: #f8f9fa;
}

.btn-group .btn {
    padding: 0.25rem 0.5rem;
}

.badge {
    font-weight: 500;
    padding: 0.35em 0.65em;
}

.modal-lg {
    max-width: 900px;
}

.worker-row:hover {
    background-color: #f8f9fa;
}

.form-control-sm {
    padding: 0.25rem 0.5rem;
    font-size: 0.875rem;
}

@media (max-width: 768px) {
    .modal-lg {
        max-width: 100%;
        margin: 0.5rem;
    }
}
</style>
@endpush
@endsection