@props(['vouchers', 'subAgents'])

<div class="tab-pane fade {{ $activeTab === 'vouchers' ? 'show active' : '' }}" id="vouchers">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Payment Vouchers</h5>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createVoucherModal">
                <i class="fas fa-plus"></i> New Voucher
            </button>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Voucher #</th>
                            <th>Date</th>
                            <th>Sub Agent</th>
                            <th>Workers</th>
                            <th>Total Amount</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($vouchers as $voucher)
                            <tr>
                                <td>{{ $voucher->voucher_number }}</td>
                                <td>{{ $voucher->created_at->format('Y-m-d') }}</td>
                                <td>{{ $voucher->subAgent->name }}</td>
                                <td>{{ $voucher->workers->count() }}</td>
                                <td>${{ number_format($voucher->total_amount, 2) }}</td>
                                <td>
                                    <span class="badge bg-{{ $voucher->status === 'paid' ? 'success' : 'warning' }}">
                                        {{ ucfirst($voucher->status) }}
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('vouchers.show', $voucher) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('vouchers.edit', $voucher) }}" class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button type="button" class="btn btn-sm btn-danger" 
                                                onclick="deleteVoucher({{ $voucher->id }})">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center">No vouchers found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @if(method_exists($vouchers, 'links'))
                <div class="mt-3">
                    {{ $vouchers->links() }}
                </div>
            @endif
        </div>
    </div>
</div> 