@extends('layouts.jobs')
<!DOCTYPE html>
<html lang="en">
<head>
    
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="../static/img/favicon.ico" sizes="192x192" />
    <link rel="apple-touch-icon" href="static/img/favicon.ico" />
    <title>Professional Recruitment & Travel Consulting Services</title>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <link rel="stylesheet" href="{{ asset('css/jobs/styles.css') }}">
    <!-- Bootstrap Icons -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">    <link rel="stylesheet" href="../static/css/styles.css">
   
   </head>
<body>
   
<main>

  

    <section class="py-4 py-lg-5">
        <div class="container">
            <h2 class="text-center mb-4">Available Job Opportunities</h2>
            
            <!-- Search/Filter Bar -->
            <div class="row mb-4">
                <div class="col-md-10 mx-auto">
                    <div class="input-group mb-3">
                        <input type="text" id="jobs-search-input" class="form-control" placeholder="Job title, company, or keywords">
                        <select id="location-filter" class="form-select" style="max-width: 150px;">
                            <option>All Locations</option>
                            <option>UAE</option>
                            <option>Saudi Arabia</option>
                            <option>Qatar</option>
                            <option>Kuwait</option>
                        </select>
                        <select id="salary-filter" class="form-select" style="max-width: 150px;">
                            <option>Salary Range</option>
                            <option>5,000+ AED</option>
                            <option>10,000+ AED</option>
                            <option>15,000+ AED</option>
                        </select>
                        <button id="jobs-search-btn" class="btn btn-blue" type="button">
                            <i class="bi bi-search"></i> Search
                        </button>
                    </div>
                    <div class="d-flex flex-wrap gap-2">
                        <span class="badge bg-light text-dark border filter-badge active">All Jobs</span>
                        <span class="badge bg-light text-dark border filter-badge">Full-time</span>
                        <span class="badge bg-light text-dark border filter-badge">Contract</span>
                        <span class="badge bg-light text-dark border filter-badge">High Salary</span>
                        <span class="badge bg-light text-dark border filter-badge">Urgent Hiring</span>
                    </div>
                </div>
            </div>
    
            <!-- Jobs Container -->
            <div class="row mt-4" id="jobs-container">
                <!-- Job Posting 1 -->
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="job-card">
                        <div class="job-header">
                            <h3>House-to-House Maid</h3>
                            <span class="badge bg-primary">Part-time</span>
                        </div>
                        <div class="job-meta">
                            <p><i class="bi bi-building"></i> Domestic Services</p>
                            <p><i class="bi bi-geo-alt"></i> Doha, Qatar</p>
                            <p><i class="bi bi-cash-stack"></i> <strong>1,200 QAR/month</strong></p>
                            <p><i class="bi bi-calendar-event"></i> Posted: 30 Mar 2025</p>
                            <p><i class="bi bi-clock-history"></i> Closes in: <strong>15 days</strong></p>
                        </div>
                        <p class="job-desc">Reliable maid for house cleaning services at multiple locations. Flexible hours, must have own transportation. Experience preferred but not required.</p>
                        <div class="job-skills">
                            <span class="skill-tag">Cleaning</span>
                            <span class="skill-tag">Laundry</span>
                            <span class="skill-tag">Housekeeping</span>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <a href="#" class="text-blue"><i class="bi bi-bookmark"></i> Save</a>
                            <a href="apply.html" class="btn btn-sm btn-blue">Apply Now <i class="bi bi-arrow-right"></i></a>
                         </div>
                    </div>
                </div>
            
                <!-- Job Posting 2 -->
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="job-card">
                        <div class="job-header">
                            <h3>House Maid</h3>
                            <span class="badge bg-success">Part-time</span>
                            <span class="badge bg-info">Urgent Hiring</span>
                        </div>
                        <div class="job-meta">
                            <p><i class="bi bi-building"></i> Domestic Services Co.</p>
                            <p><i class="bi bi-geo-alt"></i> Riyadh, Saudi Arabia</p>
                            <p><i class="bi bi-cash-stack"></i> <strong>900 - 1,000 SAR/month</strong></p>
                            <p><i class="bi bi-calendar-event"></i> Posted: 15 Jan 2024</p>
                            <p><i class="bi bi-clock-history"></i> Closes in: <strong>7 days</strong></p>
                        </div>
                        <p class="job-desc">Seeking reliable house maid for cleaning and household duties. Salary varies based on experience. Accommodation not provided.</p>
                        <div class="job-skills">
                            <span class="skill-tag">Cleaning</span>
                            <span class="skill-tag">Laundry</span>
                            <span class="skill-tag">Housekeeping</span>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <a href="#" class="text-blue"><i class="bi bi-bookmark"></i> Save</a>
                                                        <a href="apply.html" class="btn btn-sm btn-blue">Apply Now <i class="bi bi-arrow-right"></i></a>

                        </div>
                    </div>
                </div>
    
                <!-- Job Posting 3 -->
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="job-card">
                        <div class="job-header">
                            <h3>Construction Engineer</h3>
                            <span class="badge bg-info text-dark">Contract</span>
                            <span class="badge bg-danger">Urgent</span>
                        </div>
                        <div class="job-meta">
                            <p><i class="bi bi-building"></i> Desert Builders LLC</p>
                            <p><i class="bi bi-geo-alt"></i> Doha, Qatar</p>
                            <p><i class="bi bi-cash-stack"></i> <strong>15,000 - 18,000 QAR/month</strong></p>
                            <p><i class="bi bi-calendar-event"></i> Posted: 10 June 2023</p>
                            <p><i class="bi bi-clock-history"></i> Closes in: <strong>5 days</strong></p>
                        </div>
                        <p class="job-desc">Site engineer for high-rise project. Must have 5+ years GCC experience and engineering certification.</p>
                        <div class="job-skills">
                            <span class="skill-tag">Civil Engineering</span>
                            <span class="skill-tag">AutoCAD</span>
                            <span class="skill-tag">GCC Experience</span>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <a href="#" class="text-blue"><i class="bi bi-bookmark"></i> Save</a>
                            <a href="apply.html" class="btn btn-sm btn-blue">Apply Now <i class="bi bi-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
    
                <!-- Job Posting 4 -->
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="job-card">
                        <div class="job-header">
                            <h3>Hotel Manager</h3>
                            <span class="badge bg-primary">Full-time</span>
                        </div>
                        <div class="job-meta">
                            <p><i class="bi bi-building"></i> Luxury Hotels Group</p>
                            <p><i class="bi bi-geo-alt"></i> Abu Dhabi, UAE</p>
                            <p><i class="bi bi-cash-stack"></i> <strong>30,000 AED/month + Benefits</strong></p>
                            <p><i class="bi bi-calendar-event"></i> Posted: 5 June 2023</p>
                            <p><i class="bi bi-clock-history"></i> Closes in: <strong>18 days</strong></p>
                        </div>
                        <p class="job-desc">5-star hotel operations manager. Requires 8+ years luxury hospitality experience and degree in Hotel Management.</p>
                        <div class="job-skills">
                            <span class="skill-tag">Hospitality</span>
                            <span class="skill-tag">Operations</span>
                            <span class="skill-tag">Luxury Brands</span>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <a href="#" class="text-blue"><i class="bi bi-bookmark"></i> Save</a>
                            <a href="apply.html" class="btn btn-sm btn-blue">Apply Now <i class="bi bi-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
    
                <!-- Job Posting 5 -->
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="job-card">
                        <div class="job-header">
                            <h3>IT Project Manager</h3>
                            <span class="badge bg-primary">Full-time</span>
                            <span class="badge bg-warning text-dark">High Salary</span>
                        </div>
                        <div class="job-meta">
                            <p><i class="bi bi-building"></i> Tech Solutions Gulf</p>
                            <p><i class="bi bi-geo-alt"></i> Dubai, UAE</p>
                            <p><i class="bi bi-cash-stack"></i> <strong>22,000 - 28,000 AED/month</strong></p>
                            <p><i class="bi bi-calendar-event"></i> Posted: 12 June 2023</p>
                            <p><i class="bi bi-clock-history"></i> Closes in: <strong>14 days</strong></p>
                        </div>
                        <p class="job-desc">Manage enterprise software implementations. PMP certification required with 7+ years IT project management.</p>
                        <div class="job-skills">
                            <span class="skill-tag">PMP</span>
                            <span class="skill-tag">Agile</span>
                            <span class="skill-tag">ERP Systems</span>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <a href="#" class="text-blue"><i class="bi bi-bookmark"></i> Save</a>
                            <a href="apply.html" class="btn btn-sm btn-blue">Apply Now <i class="bi bi-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
    
                <!-- Job Posting 6 -->
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="job-card">
                        <div class="job-header">
                            <h3>Sales Executive</h3>
                            <span class="badge bg-primary">Full-time</span>
                            <span class="badge bg-success">Commission</span>
                        </div>
                        <div class="job-meta">
                            <p><i class="bi bi-building"></i> Gulf Trading Co.</p>
                            <p><i class="bi bi-geo-alt"></i> Jeddah, Saudi Arabia</p>
                            <p><i class="bi bi-cash-stack"></i> <strong>6,000 SAR + Commission</strong></p>
                            <p><i class="bi bi-calendar-event"></i> Posted: 8 June 2023</p>
                            <p><i class="bi bi-clock-history"></i> Closes in: <strong>9 days</strong></p>
                        </div>
                        <p class="job-desc">B2B sales role in industrial equipment. Uncapped commission structure. Arabic/English bilingual required.</p>
                        <div class="job-skills">
                            <span class="skill-tag">Sales</span>
                            <span class="skill-tag">B2B</span>
                            <span class="skill-tag">Arabic</span>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <a href="#" class="text-blue"><i class="bi bi-bookmark"></i> Save</a>
                            <a href="apply.html" class="btn btn-sm btn-blue">Apply Now <i class="bi bi-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
            </div>
    
               <!-- Pagination -->
            <nav class="mt-5">
                <ul class="pagination justify-content-center">
                    <li class="page-item disabled">
                        <a class="page-link" href="#" tabindex="-1">Previous</a>
                    </li>
                    <li class="page-item active"><a class="page-link" href="#">1</a></li>
                    <li class="page-item"><a class="page-link" href="#">2</a></li>
                    <li class="page-item"><a class="page-link" href="#">3</a></li>
                    <li class="page-item">
                        <a class="page-link" href="#">Next</a>
                    </li>
                </ul>
            </nav>
        </div>
    </section>
    
    
   
    
<link crossorigin="anonymous" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" rel="stylesheet">
<script crossorigin="anonymous" integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p" src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<button id="backToTop" title="Go to top" aria-label="Back to top">↑</button>

<a href="https://wa.me/254724101366" class="whatsapp-float">
    <i class="bi bi-whatsapp"></i>
  </a>
  <script>
document.addEventListener('DOMContentLoaded', () => {
    const jobsContainer = document.getElementById('jobs-container');
    const searchInput = document.getElementById('jobs-search-input');
    const locationFilter = document.getElementById('location-filter');
    const salaryFilter = document.getElementById('salary-filter');
    const filterBadges = document.querySelectorAll('.filter-badge');
    const searchBtn = document.getElementById('jobs-search-btn');

    function normalizeText(text) {
        return text.toLowerCase();
    }

    function parseSalary(salaryText) {
        const match = salaryText.replace(/[^0-9\-]/g, '').split('-').map(Number);
        return match.length > 1 ? match[1] : match[0];
    }

    function getActiveFilterType() {
        const active = document.querySelector('.filter-badge.active');
        return active && active.textContent !== 'All Jobs' ? active.textContent : null;
    }

    function filterJobs() {
        const searchTerm = normalizeText(searchInput.value.trim());
        const locationVal = locationFilter.value;
        const salaryVal = salaryFilter.value;
        const filterType = getActiveFilterType();

        const cards = jobsContainer.querySelectorAll('.job-card');

        cards.forEach(card => {
            const title = normalizeText(card.querySelector('.job-header h3').textContent);
            const company = normalizeText(card.querySelector('.job-meta').textContent);
            const description = normalizeText(card.querySelector('.job-desc').textContent);
            const location = card.querySelector('.bi-geo-alt')?.parentElement.textContent || '';
            const salaryText = card.querySelector('.bi-cash-stack')?.parentElement.textContent || '';
            const badges = Array.from(card.querySelectorAll('.job-header .badge')).map(b => b.textContent.trim());
            const combinedText = `${title} ${company} ${description}`;

            let show = true;

            // Search match
            if (searchTerm && !combinedText.includes(searchTerm)) {
                show = false;
            }

            // Location filter
            if (locationVal !== 'All Locations' && !location.includes(locationVal)) {
                show = false;
            }

            // Salary filter
            if (salaryVal !== 'Salary Range') {
                const minSalary = parseInt(salaryVal.replace(/[^0-9]/g, ''), 10);
                const actualSalary = parseSalary(salaryText);
                if (actualSalary < minSalary) {
                    show = false;
                }
            }

            // Filter badge (type, urgent, etc.)
            if (filterType && !badges.includes(filterType)) {
                show = false;
            }

            card.closest('.col-md-6').style.display = show ? 'block' : 'none';
        });
    }

    searchBtn.addEventListener('click', filterJobs);
    searchInput.addEventListener('keyup', event => {
        if (event.key === 'Enter') filterJobs();
    });

    locationFilter.addEventListener('change', filterJobs);
    salaryFilter.addEventListener('change', filterJobs);

    filterBadges.forEach(badge => {
        badge.addEventListener('click', () => {
            filterBadges.forEach(b => b.classList.remove('active'));
            badge.classList.add('active');
            filterJobs();
        });
    });
});
</script>
</body>
</html>