<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            @yield('title', 'Super Admin Dashboard')
        </h2>
    </x-slot>

    <!-- User Dashboard Content -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
        <div class="flex flex-col md:flex-row gap-6">
            <!-- Main Content -->
            <div class="flex-1">
                <div class="bg-white rounded-lg shadow-sm overflow-hidden">
                    <div class="p-6">
                        @yield('content')
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- SweetAlert2 CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.32/dist/sweetalert2.min.css">
    
    <!-- jQuery (required for AJAX) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- SweetAlert2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.32/dist/sweetalert2.all.min.js"></script>

    <!-- Toast Configuration -->
    <script>
        // Toast configuration
        const Toast = Swal.mixin({
            toast: true,
            position: 'center',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            customClass: {
                popup: 'colored-toast'
            },
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        });

        // Custom styles for centered toasts
        const style = document.createElement('style');
        style.textContent = `
            .colored-toast {
                background-color: white !important;
                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15) !important;
                border-radius: 8px !important;
                padding: 16px !important;
                min-width: 300px !important;
                max-width: 500px !important;
            }
            .colored-toast.swal2-icon-success {
                border-left: 4px solid #28a745 !important;
            }
            .colored-toast.swal2-icon-error {
                border-left: 4px solid #dc3545 !important;
            }
            .colored-toast.swal2-icon-warning {
                border-left: 4px solid #ffc107 !important;
            }
            .colored-toast.swal2-icon-info {
                border-left: 4px solid #17a2b8 !important;
            }
            .colored-toast .swal2-title {
                color: #333 !important;
                font-size: 16px !important;
                font-weight: 500 !important;
            }
            .colored-toast .swal2-timer-progress-bar {
                background: rgba(0, 0, 0, 0.1) !important;
            }
        `;
        document.head.appendChild(style);

        // Display session messages as toasts
        @if(session('success'))
            Toast.fire({
                icon: 'success',
                title: "{{ session('success') }}"
            });
        @endif

        @if(session('error'))
            Toast.fire({
                icon: 'error',
                title: "{{ session('error') }}"
            });
        @endif

        @if(session('warning'))
            Toast.fire({
                icon: 'warning',
                title: "{{ session('warning') }}"
            });
        @endif

        @if(session('info'))
            Toast.fire({
                icon: 'info',
                title: "{{ session('info') }}"
            });
        @endif
    </script>
</x-app-layout>