@extends('layouts.superadmin-dashboard')

@section('title', 'Super Admin Dashboard')

@section('content')
<div class="container-fluid mt-4">
    <!-- Search Bar -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-body">
                    <form action="{{ route('superadmin.dashboard') }}" method="GET" class="d-flex gap-2">
                        <div class="flex-grow-1">
                            <input type="text" name="search" class="form-control" placeholder="Search users, workers, or applications..." value="{{ request('search') }}">
                        </div>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-search"></i> Search
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Users</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalUsers }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Active Workers</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $activeWorkers }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-tie fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Pending Applications</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $pendingApplications }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clipboard-list fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Total Invoices</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalInvoices }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-file-invoice-dollar fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- System Health and Quick Actions -->
    <div class="row mb-4">
        <!-- System Health -->
        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">System Health</h5>
                </div>
                <div class="card-body">
                    <div class="system-health-item mb-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <span>Server Status</span>
                            <span class="badge bg-success">Online</span>
                        </div>
                        <div class="progress mt-2" style="height: 5px;">
                            <div class="progress-bar bg-success" style="width: 100%"></div>
                        </div>
                    </div>
                    <div class="system-health-item mb-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <span>Database Status</span>
                            <span class="badge bg-success">Connected</span>
                        </div>
                        <div class="progress mt-2" style="height: 5px;">
                            <div class="progress-bar bg-success" style="width: 100%"></div>
                        </div>
                    </div>
                    <div class="system-health-item">
                        <div class="d-flex justify-content-between align-items-center">
                            <span>Storage Usage</span>
                            <span class="badge bg-info">65%</span>
                        </div>
                        <div class="progress mt-2" style="height: 5px;">
                            <div class="progress-bar bg-info" style="width: 65%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="col-lg-8">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Quick Actions</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <a href="{{ route('workers.create') }}" class="btn btn-outline-primary btn-block">
                                <i class="fas fa-user-plus"></i> Add New Worker
                            </a>
                        </div>
                        <div class="col-md-3 mb-3">
                            <a href="{{ route('jobs.create') }}" class="btn btn-outline-success btn-block">
                                <i class="fas fa-briefcase"></i> Post New Job
                            </a>
                        </div>
                        <div class="col-md-3 mb-3">
                            <a href="{{ route('invoices.create') }}" class="btn btn-outline-info btn-block">
                                <i class="fas fa-file-invoice"></i> Create Invoice
                            </a>
                        </div>
                        <div class="col-md-3 mb-3">
                            <a href="{{ route('vouchers.create') }}" class="btn btn-outline-warning btn-block">
                                <i class="fas fa-ticket-alt"></i> Generate Voucher
                            </a>
                        </div>
                        <div class="col-md-3 mb-3">
                            <a href="{{ route('reports.index') }}" class="btn btn-outline-secondary btn-block">
                                <i class="fas fa-chart-bar"></i> Generate Reports
                            </a>
                        </div>
                        <div class="col-md-3 mb-3">
                            <a href="{{ route('settings.index') }}" class="btn btn-outline-dark btn-block">
                                <i class="fas fa-cog"></i> System Settings
                            </a>
                        </div>
                        <div class="col-md-3 mb-3">
                            <a href="{{ route('backup.create') }}" class="btn btn-outline-danger btn-block">
                                <i class="fas fa-database"></i> Backup System
                            </a>
                        </div>
                        <div class="col-md-3 mb-3">
                            <a href="{{ route('logs.view') }}" class="btn btn-outline-info btn-block">
                                <i class="fas fa-history"></i> View Logs
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- User Management -->
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">User Management</h5>
                    <div class="btn-group">
                        <button type="button" class="btn btn-light btn-sm" data-bs-toggle="modal" data-bs-target="#exportModal">
                            <i class="fas fa-download"></i> Export
                        </button>
                        <button type="button" class="btn btn-light btn-sm" data-bs-toggle="modal" data-bs-target="#importModal">
                            <i class="fas fa-upload"></i> Import
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Role</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($users as $user)
                                <tr>
                                    <td>{{ $user->name }}</td>
                                    <td>{{ $user->email }}</td>
                                    <td>
                                        <form action="{{ route('superadmin.update-role', $user->id) }}" method="POST" class="d-flex role-update-form">
                                            @csrf
                                            <div class="input-group">
                                                <select name="role" class="form-select" aria-label="Select Role">
                                                    @foreach ($roles as $value => $label)
                                                        <option value="{{ $value }}" {{ $user->role === $value ? 'selected' : '' }}>
                                                            {{ $label }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <button type="submit" class="btn btn-success ms-2">
                                                    <i class="fas fa-save"></i>
                                                </button>
                                            </div>
                                        </form>
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $user->is_active ? 'success' : 'danger' }}">
                                            {{ $user->is_active ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('superadmin.view-user', $user->id) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <button type="button" class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editUserModal{{ $user->id }}">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button type="button" class="btn btn-danger btn-sm delete-user" data-user-id="{{ $user->id }}">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center">
                        {{ $users->links() }}
                    </div>
                </div>
            </div>

            <!-- Recent Logins -->
            <div class="card shadow mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Recent Logins</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered mb-0">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Role</th>
                                    <th>Last Login</th>
                                    <th>IP Address</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($recentLogins as $login)
                                <tr>
                                    <td>{{ $login->name }}</td>
                                    <td>{{ $login->email }}</td>
                                    <td>{{ ucfirst($login->role) }}</td>
                                    <td>{{ $login->last_login_at ? $login->last_login_at->format('Y-m-d H:i') : '-' }}</td>
                                    <td>{{ $login->last_login_ip ?? '-' }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" class="text-center">No recent logins found.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activities and Notifications -->
        <div class="col-lg-4">
            <!-- Audit Trail -->
            <div class="card shadow mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Audit Trail</h5>
                </div>
                <div class="card-body">
                    <div class="activity-feed">
                        @forelse($recentActivities as $activity)
                        <div class="activity-item mb-3">
                            <div class="d-flex align-items-center">
                                <div class="activity-icon me-3">
                                    <i class="fas fa-history text-info"></i>
                                </div>
                                <div class="activity-content">
                                    <p class="mb-0">{{ $activity->description }}</p>
                                    <small class="text-muted">{{ $activity->created_at->diffForHumans() }}</small>
                                </div>
                            </div>
                        </div>
                        @empty
                        <div class="text-center text-muted">No recent activities found.</div>
                        @endforelse
                    </div>
                </div>
            </div>

            <!-- Notifications -->
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Notifications</h5>
                </div>
                <div class="card-body">
                    <div class="notification-list">
                        @foreach($notifications as $notification)
                        <div class="notification-item mb-3 p-2 rounded {{ $notification->read_at ? 'bg-light' : 'bg-white' }}">
                            <div class="d-flex align-items-center">
                                <div class="notification-icon me-3">
                                    <i class="fas {{ $notification->icon }} text-{{ $notification->type }}"></i>
                                </div>
                                <div class="notification-content">
                                    <p class="mb-0">{{ $notification->message }}</p>
                                    <small class="text-muted">{{ $notification->created_at->diffForHumans() }}</small>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Export Modal -->
<div class="modal fade" id="exportModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Export Users</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('superadmin.export-users') }}" method="GET">
                    <div class="mb-3">
                        <label class="form-label">Export Format</label>
                        <select name="format" class="form-select">
                            <option value="csv">CSV</option>
                            <option value="excel">Excel</option>
                            <option value="pdf">PDF</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Date Range</label>
                        <div class="input-group">
                            <input type="date" name="start_date" class="form-control">
                            <span class="input-group-text">to</span>
                            <input type="date" name="end_date" class="form-control">
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">Export</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Import Modal -->
<div class="modal fade" id="importModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Import Users</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('superadmin.import-users') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="mb-3">
                        <label class="form-label">Select File</label>
                        <input type="file" name="file" class="form-control" accept=".csv,.xlsx">
                    </div>
                    <div class="mb-3">
                        <a href="{{ route('superadmin.download-template') }}" class="text-decoration-none">
                            <i class="fas fa-download"></i> Download Template
                        </a>
                    </div>
                    <button type="submit" class="btn btn-primary">Import</button>
                </form>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
.border-left-primary { border-left: 4px solid #4e73df !important; }
.border-left-success { border-left: 4px solid #1cc88a !important; }
.border-left-warning { border-left: 4px solid #f6c23e !important; }
.border-left-info { border-left: 4px solid #36b9cc !important; }
.activity-feed, .notification-list {
    max-height: 300px;
    overflow-y: auto;
}
.activity-item, .notification-item {
    padding: 10px;
    border-bottom: 1px solid #eee;
}
.activity-item:last-child, .notification-item:last-child {
    border-bottom: none;
}
.activity-icon, .notification-icon {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    background: #f8f9fc;
}
.system-health-item {
    padding: 10px;
    border-bottom: 1px solid #eee;
}
.system-health-item:last-child {
    border-bottom: none;
}
</style>
@endpush

@push('scripts')
<script>
$(document).ready(function() {
    // Handle role update form submissions
    $('.role-update-form').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = form.find('button[type="submit"]');
        
        submitButton.prop('disabled', true);
        
        $.ajax({
            url: form.attr('action'),
            method: 'POST',
            data: form.serialize(),
            success: function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Success!',
                    text: 'User role updated successfully',
                    position: 'center',
                    showConfirmButton: false,
                    timer: 1500
                });
            },
            error: function(xhr) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: xhr.responseJSON?.message || 'Failed to update user role',
                    position: 'center'
                });
            },
            complete: function() {
                submitButton.prop('disabled', false);
            }
        });
    });

    // Handle user deletion
    $('.delete-user').on('click', function() {
        const userId = $(this).data('user-id');
        
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: `/superadmin/users/${userId}`,
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Deleted!',
                            text: 'User has been deleted.',
                            position: 'center',
                            showConfirmButton: false,
                            timer: 1500
                        }).then(() => {
                            location.reload();
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: xhr.responseJSON?.message || 'Failed to delete user',
                            position: 'center'
                        });
                    }
                });
            }
        });
    });

    // Handle notification clicks
    $('.notification-item').on('click', function() {
        const notificationId = $(this).data('notification-id');
        if (notificationId) {
            $.ajax({
                url: `/notifications/${notificationId}/mark-as-read`,
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function() {
                    $(this).removeClass('bg-white').addClass('bg-light');
                }
            });
        }
    });
});
</script>
@endpush
@endsection
