@extends('adminlte::page')

@section('title', 'Edit Visitor')

@section('content_header')
    <h1>Edit Visitor</h1>
@endsection

@section('content')
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif
    <div class="card">
        <div class="card-body">
            <form action="{{ route('visitors.update', $visitor->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="form-group">
                    <label for="name">Visitor Name</label>
                    <input type="text" name="name" id="name" class="form-control" value="{{ $visitor->name }}" required>
                    @error('name')
                        <div class="text-danger small">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="email">Email (Optional)</label>
                    <input type="email" name="email" id="email" class="form-control" value="{{ $visitor->email }}">
                    @error('email')
                        <div class="text-danger small">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="phone">Phone (Optional)</label>
                    <input type="text" name="phone" id="phone" class="form-control" value="{{ $visitor->phone }}">
                    @error('phone')
                        <div class="text-danger small">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="purpose">Purpose of Visit</label>
                    <textarea name="purpose" id="purpose" class="form-control" rows="3">{{ $visitor->purpose }}</textarea>
                    @error('purpose')
                        <div class="text-danger small">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="check_in_time">Check-in Time</label>
                    <input type="text" name="check_in_time" id="check_in_time" class="form-control" value="{{ $visitor->check_in_time }}" readonly>
                    @error('check_in_time')
                        <div class="text-danger small">{{ $message }}</div>
                    @enderror
                </div>

                <button type="submit" class="btn btn-primary">Update Visitor</button>
                <a href="{{ route('visitors.index') }}" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
@endsection
