@extends('layouts.visitors')

@section('title', 'Visitor Details')

@section('content')
<div class="container mt-4">
    <div class="card">
        <div class="card-header">
            <h3>Visitor Details</h3>
        </div>
        <div class="card-body">
            <p><strong>Name:</strong> {{ $visitor->name }}</p>
            <p><strong>Email:</strong> {{ $visitor->email ?? 'N/A' }}</p>
            <p><strong>Phone:</strong> {{ $visitor->phone ?? 'N/A' }}</p>
            <p><strong>Purpose:</strong> {{ $visitor->purpose }}</p>
            <p><strong>Check-in:</strong> {{ $visitor->check_in ? \Carbon\Carbon::parse($visitor->check_in)->format('d M Y H:i') : 'N/A' }}</p>
            <p><strong>Check-out:</strong> {{ $visitor->check_out ? \Carbon\Carbon::parse($visitor->check_out)->format('d M Y H:i') : 'N/A' }}</p>
            <a href="{{ route('visitors.index') }}" class="btn btn-secondary">Back</a>
        </div>
    </div>
</div>
@endsection 