@extends('layouts.vouchers')

@section('content')
<div class="container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="mb-0">Voucher Details</h4>
        <div>
            <a href="{{ route('vouchers.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to List
            </a>
            @if($voucher->canBeEdited())
                <form action="{{ route('vouchers.destroy', $voucher) }}" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this voucher?')">
                        <i class="fas fa-trash"></i> Delete
                    </button>
                </form>
            @endif
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Voucher Information</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Voucher Number:</strong> {{ $voucher->voucher_number }}</p>
                            <p><strong>Sub Agent:</strong> {{ $voucher->subAgent->name ?? 'N/A' }}</p>
                            <p><strong>Type:</strong> {{ ucfirst($voucher->voucher_type) }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Status:</strong>
                                <span class="badge bg-{{ $voucher->status === 'pending' ? 'warning' : ($voucher->status === 'approved' ? 'success' : ($voucher->status === 'rejected' ? 'danger' : 'secondary')) }}">
                                    {{ ucfirst($voucher->status) }}
                                </span>
                            </p>
                            <p><strong>Total Amount:</strong> {{ number_format($voucher->total_amount, 2) }}</p>
                            <p><strong>Created:</strong> {{ $voucher->created_at->format('M d, Y H:i') }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Workers</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Passport</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($voucher->workers as $worker)
                                    <tr>
                                        <td>{{ $worker->name }}</td>
                                        <td>{{ $worker->passport_number }}</td>
                                        <td>{{ number_format($worker->pivot->amount, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Actions</h5>
                </div>
                <div class="card-body">
                    @if($voucher->canBeApproved())
                        <form action="{{ route('vouchers.update-status', $voucher) }}" method="POST" class="mb-2">
                            @csrf
                            @method('PATCH')
                            <input type="hidden" name="status" value="approved">
                            <button type="submit" class="btn btn-success w-100">
                                <i class="fas fa-check"></i> Approve
                            </button>
                        </form>
                    @endif

                    @if($voucher->canBeRejected())
                        <form action="{{ route('vouchers.update-status', $voucher) }}" method="POST" class="mb-2">
                            @csrf
                            @method('PATCH')
                            <input type="hidden" name="status" value="rejected">
                            <button type="submit" class="btn btn-danger w-100">
                                <i class="fas fa-times"></i> Reject
                            </button>
                        </form>
                    @endif

                    @if($voucher->canBeCancelled())
                        <form action="{{ route('vouchers.update-status', $voucher) }}" method="POST" class="mb-2">
                            @csrf
                            @method('PATCH')
                            <input type="hidden" name="status" value="cancelled">
                            <button type="submit" class="btn btn-warning w-100">
                                <i class="fas fa-ban"></i> Cancel
                            </button>
                        </form>
                    @endif

                    @if($voucher->canBeMarkedAsPaid())
                        <form action="{{ route('vouchers.update-status', $voucher) }}" method="POST">
                            @csrf
                            @method('PATCH')
                            <input type="hidden" name="status" value="paid">
                            <button type="submit" class="btn btn-info w-100">
                                <i class="fas fa-money-bill"></i> Mark as Paid
                            </button>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
