@extends('layouts.workers')

@section('content')
<div class="container">
    <div class="max-w-6xl mx-auto">
        <div class="bg-white rounded-xl shadow-md overflow-hidden">
           
            <!-- Header -->
            <div class="bg-blue-600 px-6 py-4">
                        <div class="flex justify-between items-center">
                            <div>
                                <h2 class="text-2xl font-bold text-blue">Edit Candidate Profile</h2>
                                <p class="text-blue-100">Update the candidate information below</p>
                            </div>
                            <a href="{{ route('workers.index') }}" class="text-blue hover:text-blue-200">
                                <i class="fas fa-arrow-left"></i> Back to List
                            </a>
                        </div>
                    </div>

            <!-- Main Form -->
            <div class="p-6">
                <!-- Success/Error Messages -->
                @if ($errors->any())
                    <div class="mb-6 p-4 bg-red-50 border-l-4 border-red-500 text-red-700 rounded">
                        <div class="font-bold">Please fix the following errors:</div>
                        <ul class="mt-2 list-disc list-inside">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form action="{{ route('workers.update', $worker->id) }}" method="POST" enctype="multipart/form-data" class="space-y-6">
                    @csrf
                    @method('PUT')

                    <!-- Profile Picture Section - Matching Passport Style -->
                            <div class="mt-6">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Profile Photo</label>
                            <div class="flex flex-col md:flex-row items-center gap-8">
                                @if ($worker->profile_picture)
                                <div class="text-center">
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Current Photo</label>
                                    <img id="profilePreview" class="rounded-lg border shadow-md w-48 h-48 object-cover" 
                                        src="{{ asset('storage/worker_photos/'.$worker->profile_picture) }}">
                                </div>
                                @else
                                <div class="text-center">
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Current Photo</label>
                                    <div class="w-48 h-48 bg-gray-200 rounded-lg flex items-center justify-center">
                                    <span class="text-gray-500">No photo</span>
                                    </div>
                                    <img id="profilePreview" class="rounded-lg border shadow-md w-48 h-48 object-cover hidden">
                                </div>
                                @endif
                                
                                <div class="flex-1">
                                <div class="flex items-center justify-center w-full">
                                    <label for="profileInput" class="flex flex-col items-center justify-center w-full h-32 border-2 border-gray-300 border-dashed rounded-lg cursor-pointer bg-gray-50 hover:bg-gray-100">
                                    <div class="flex flex-col items-center justify-center pt-5 pb-6">
                                        <svg class="w-8 h-8 mb-4 text-gray-500" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 16">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 13h3a3 3 0 0 0 0-6h-.025A5.56 5.56 0 0 0 16 6.5 5.5 5.5 0 0 0 5.207 5.021C5.137 5.017 5.071 5 5 5a4 4 0 0 0 0 8h2.167M10 15V6m0 0L8 8m2-2 2 2"/>
                                        </svg>
                                        <p class="mb-2 text-sm text-gray-500">
                                        <span class="font-semibold">Click to upload</span> or drag and drop
                                        </p>
                                        <p class="text-xs text-gray-500">JPG, PNG (MAX. 2MB)</p>
                                    </div>
                                    <input id="profileInput" name="profile_picture" type="file" class="hidden" accept=".jpg,.jpeg,.png" onchange="previewProfile(event)"/>
                                    </label>
                                </div>
                                </div>
                            </div>
                            </div>



                    <!-- Personal Information Section -->
                    <div class="bg-gray-50 p-6 rounded-lg border border-gray-200">
                        <div class="flex items-center mb-4">
                            <div class="bg-blue-600 w-2 h-8 mr-3 rounded-full"></div>
                            <h3 class="text-xl font-semibold text-gray-800">Personal Information</h3>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Name Fields -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Surname *</label>
                                <input type="text" name="surname" value="{{ $worker->surname }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Given Names *</label>
                                <input type="text" name="given_names" value="{{ $worker->given_names }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>

                            <!-- DOB and Gender -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Date of Birth *</label>
                                <input type="date" name="date_of_birth" value="{{ $worker->date_of_birth }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Gender *</label>
                                <select name="gender" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                                    <option value="Male" {{ $worker->gender == 'Male' ? 'selected' : '' }}>Male</option>
                                    <option value="Female" {{ $worker->gender == 'Female' ? 'selected' : '' }}>Female</option>
                                    <option value="Other" {{ $worker->gender == 'Other' ? 'selected' : '' }}>Other</option>
                                </select>
                            </div>

                            <!-- Marital Status and Religion -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Marital Status *</label>
                                <select name="marital_status" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                                    <option value="Single" {{ $worker->marital_status == 'Single' ? 'selected' : '' }}>Single</option>
                                    <option value="Married" {{ $worker->marital_status == 'Married' ? 'selected' : '' }}>Married</option>
                                    <option value="Divorced" {{ $worker->marital_status == 'Divorced' ? 'selected' : '' }}>Divorced</option>
                                    <option value="Widowed" {{ $worker->marital_status == 'Widowed' ? 'selected' : '' }}>Widowed</option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Religion *</label>
                                <select name="religion" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                                    <option value="Muslim" {{ $worker->religion == 'Muslim' ? 'selected' : '' }}>Muslim</option>
                                    <option value="Non Muslim" {{ $worker->religion == 'Non Muslim' ? 'selected' : '' }}>Non Muslim</option>
                                </select>
                            </div>

                            <!-- Occupation and ID -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Occupation *</label>
                                <select name="occupation" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                                    <option value="">Select Occupation</option>
                                    <option value="Software Engineer" {{ $worker->occupation == 'Software Engineer' ? 'selected' : '' }}>Software Engineer</option>
                                    <option value="Data Analyst" {{ $worker->occupation == 'Data Analyst' ? 'selected' : '' }}>Data Analyst</option>
                                    <option value="Product Manager" {{ $worker->occupation == 'Product Manager' ? 'selected' : '' }}>Product Manager</option>
                                    <option value="Web Developer" {{ $worker->occupation == 'Web Developer' ? 'selected' : '' }}>Web Developer</option>
                                    <option value="HR Manager" {{ $worker->occupation == 'HR Manager' ? 'selected' : '' }}>HR Manager</option>
                                    <option value="Marketing Specialist" {{ $worker->occupation == 'Marketing Specialist' ? 'selected' : '' }}>Marketing Specialist</option>
                                    <option value="Sales Executive" {{ $worker->occupation == 'Sales Executive' ? 'selected' : '' }}>Sales Executive</option>
                                    <option value="Customer Support" {{ $worker->occupation == 'Customer Support' ? 'selected' : '' }}>Customer Support</option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">ID Number *</label>
                                <input type="text" name="id_number" value="{{ $worker->id_number }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>
                        </div>
                    </div>

                    <!-- Education & Skills Section -->
                    <div class="bg-gray-50 p-6 rounded-lg border border-gray-200">
                        <div class="flex items-center mb-4">
                            <div class="bg-blue-600 w-2 h-8 mr-3 rounded-full"></div>
                            <h3 class="text-xl font-semibold text-gray-800">Education & Skills</h3>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Education -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Education Level</label>
                                <input type="text" name="education_level" value="{{ old('education_level', $worker->education_level) }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Work Experience</label>
                                <input type="text" name="work_experience" value="{{ old('work_experience', $worker->work_experience) }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500">
                            </div>

                            <!-- Skills -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Skills *</label>
                                <select name="skills[]" multiple class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 multiselect" required>
                                    <option value="Cooking" {{ in_array('Cooking', explode(',', $worker->skills)) ? 'selected' : '' }}>Cooking</option>
                                    <option value="Driving" {{ in_array('Driving', explode(',', $worker->skills)) ? 'selected' : '' }}>Driving</option>
                                    <option value="Data Analysis" {{ in_array('Data Analysis', explode(',', $worker->skills)) ? 'selected' : '' }}>Data Analysis</option>
                                    <option value="Cleaning" {{ in_array('Cleaning', explode(',', $worker->skills)) ? 'selected' : '' }}>Cleaning</option>
                                    <option value="Gardening" {{ in_array('Gardening', explode(',', $worker->skills)) ? 'selected' : '' }}>Gardening</option>
                                    <option value="Web Development" {{ in_array('Web Development', explode(',', $worker->skills)) ? 'selected' : '' }}>Web Development</option>
                                </select>
                                <p class="mt-1 text-xs text-gray-500">Hold Ctrl/Cmd to select multiple</p>
                            </div>

                            <!-- Languages -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Languages *</label>
                                <select name="languages[]" multiple class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 multiselect" required>
                                    <option value="English" {{ in_array('English', explode(',', $worker->languages)) ? 'selected' : '' }}>English</option>
                                    <option value="Arabic" {{ in_array('Arabic', explode(',', $worker->languages)) ? 'selected' : '' }}>Arabic</option>
                                    <option value="French" {{ in_array('French', explode(',', $worker->languages)) ? 'selected' : '' }}>French</option>
                                    <option value="Swahili" {{ in_array('Swahili', explode(',', $worker->languages)) ? 'selected' : '' }}>Swahili</option>
                                </select>
                                <p class="mt-1 text-xs text-gray-500">Hold Ctrl/Cmd to select multiple</p>
                            </div>
                        </div>
                    </div>

                    
                    <!-- Passport Information Section -->
                    <div class="bg-gray-50 p-6 rounded-lg border border-gray-200">
                        <div class="flex items-center mb-4">
                            <div class="bg-blue-600 w-2 h-8 mr-3 rounded-full"></div>
                            <h3 class="text-xl font-semibold text-gray-800">Passport Information</h3>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Passport Number and Issue Place -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Passport Number *</label>
                                <input type="text" name="passport_number" value="{{ $worker->passport_number }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Passport Issue Place *</label>
                                <input type="text" name="passport_issue_place" value="{{ $worker->passport_issue_place }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>

                            <!-- Passport Dates -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Passport Issue Date *</label>
                                <input type="date" name="passport_issue_date" value="{{ $worker->passport_issue_date }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Passport Expiry Date *</label>
                                <input type="date" name="passport_expiry_date" value="{{ $worker->passport_expiry_date }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>
                        </div>

                        <!-- Passport Upload -->
                        <div class="mt-6">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Passport Document</label>
                            <div class="flex flex-col md:flex-row items-center gap-8">
                                @if ($worker->passport_file)
                                    <div class="text-center">
                                        <label class="block text-sm font-medium text-gray-700 mb-2">Current Passport</label>
                                        <img id="passportPreview" class="rounded-lg border shadow-md w-48" src="{{ asset('storage/passports/'.$worker->passport_file) }}">
                                    </div>
                                @else
                                    <div class="text-center">
                                        <label class="block text-sm font-medium text-gray-700 mb-2">Current Passport</label>
                                        <div class="w-48 h-32 bg-gray-200 rounded-lg flex items-center justify-center">
                                            <span class="text-gray-500">No file</span>
                                        </div>
                                        <img id="passportPreview" class="rounded-lg border shadow-md w-48 hidden">
                                    </div>
                                @endif
                                
                                <div class="flex-1">
                                    <div class="flex items-center justify-center w-full">
                                        <label for="passportInput" class="flex flex-col items-center justify-center w-full h-32 border-2 border-gray-300 border-dashed rounded-lg cursor-pointer bg-gray-50 hover:bg-gray-100">
                                            <div class="flex flex-col items-center justify-center pt-5 pb-6">
                                                <svg class="w-8 h-8 mb-4 text-gray-500" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 16">
                                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 13h3a3 3 0 0 0 0-6h-.025A5.56 5.56 0 0 0 16 6.5 5.5 5.5 0 0 0 5.207 5.021C5.137 5.017 5.071 5 5 5a4 4 0 0 0 0 8h2.167M10 15V6m0 0L8 8m2-2 2 2"/>
                                                </svg>
                                                <p class="mb-2 text-sm text-gray-500"><span class="font-semibold">Click to upload</span> or drag and drop</p>
                                                <p class="text-xs text-gray-500">PDF, JPG, PNG (MAX. 5MB)</p>
                                            </div>
                                            <input id="passportInput" name="passport_file" type="file" class="hidden" accept=".pdf,.jpg,.png"/>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Address Section -->
                    <div class="bg-gray-50 p-6 rounded-lg border border-gray-200">
                        <div class="flex items-center mb-4">
                            <div class="bg-blue-600 w-2 h-8 mr-3 rounded-full"></div>
                            <h3 class="text-xl font-semibold text-gray-800">Address Details</h3>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Country *</label>
                                <input type="text" name="country" value="{{ $worker->country }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">City *</label>
                                <input type="text" name="city" value="{{ $worker->city }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Place of Birth *</label>
                                <input type="text" name="place_of_birth" value="{{ $worker->place_of_birth }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Information Section -->
                    <div class="bg-gray-50 p-6 rounded-lg border border-gray-200">
                        <div class="flex items-center mb-4">
                            <div class="bg-blue-600 w-2 h-8 mr-3 rounded-full"></div>
                            <h3 class="text-xl font-semibold text-gray-800">Contact Information</h3>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Mobile Number *</label>
                                <input type="text" name="mobile_number" value="{{ $worker->mobile_number }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">E-Mail *</label>
                                <input type="email" name="email" value="{{ $worker->email }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>
                        </div>
                    </div>

                    <!-- Relative Information Section -->
                    <div class="bg-gray-50 p-6 rounded-lg border border-gray-200">
                        <div class="flex items-center mb-4">
                            <div class="bg-blue-600 w-2 h-8 mr-3 rounded-full"></div>
                            <h3 class="text-xl font-semibold text-gray-800">Relative Information</h3>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Relative Name *</label>
                                <input type="text" name="relative_name" value="{{ $worker->relative_name }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Relative Kinship *</label>
                                <input type="text" name="relative_kinship" value="{{ $worker->relative_kinship }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Relative Phone *</label>
                                <input type="text" name="relative_phone" value="{{ $worker->relative_phone }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Relative Address *</label>
                                <input type="text" name="relative_address" value="{{ $worker->relative_address }}" 
                                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" required>
                            </div>
                        </div>
                    </div>

                    <!-- Acknowledgment -->
                    <div class="bg-blue-50 p-4 rounded-lg border border-blue-200">
                        <div class="flex items-start">
                            <div class="flex items-center h-5">
                                <input id="acknowledge" name="acknowledge" type="checkbox" value="1" 
                                       class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500" 
                                       {{ $worker->acknowledge ? 'checked' : '' }} required>
                            </div>
                            <div class="ml-3">
                                <label for="acknowledge" class="font-medium text-gray-700">
                                    I acknowledge that the candidate's data entered is correct.
                                </label>
                                <p class="text-sm text-gray-500 mt-1">You must confirm this to proceed.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Form Actions -->
                    <div class="flex justify-end space-x-4 pt-6">
                        <a href="{{ url()->previous() }}" class="px-6 py-2 border border-gray-300 rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Cancel
                        </a>
                        <button type="submit" class="px-6 py-2 border border-transparent rounded-md shadow-sm text-gray bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Update Worker
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript for Image Previews -->
<script>
  // Consolidated Image Preview Handler
  function setupImagePreview(inputId, previewId, placeholderClass = null) {
    const input = document.getElementById(inputId);
    const preview = document.getElementById(previewId);
    
    if (!input || !preview) return;

    input.addEventListener('change', function(event) {
      const file = event.target.files[0];
      if (!file) return;

      // Validate file type
      const validTypes = ['image/jpeg', 'image/png', 'application/pdf'];
      if (!validTypes.includes(file.type)) {
        alert('Please upload a JPG, PNG, or PDF file');
        return;
      }

      // Validate file size (5MB max)
      if (file.size > 5 * 1024 * 1024) {
        alert('File size exceeds 5MB limit');
        return;
      }

      const reader = new FileReader();
      
      reader.onload = function(e) {
        preview.src = e.target.result;
        preview.classList.remove('hidden');
        
        // Hide placeholder if exists
        if (placeholderClass) {
          const placeholder = preview.closest('div').querySelector(placeholderClass);
          if (placeholder) placeholder.classList.add('hidden');
        }
      };
      
      reader.onerror = function() {
        console.error('Error reading file');
      };
      
      reader.readAsDataURL(file);
    });
  }

  // Initialize previews for all image uploaders
  document.addEventListener('DOMContentLoaded', function() {
    setupImagePreview('profileInput', 'profilePreview', '.bg-gray-200');
    setupImagePreview('passportInput', 'passportPreview', '.bg-gray-200');
    setupImagePreview('iqamaInput', 'iqamaPreview', '.bg-gray-200');
    setupImagePreview('visaInput', 'visaPreview', '.bg-gray-200');
    
    // Add any additional file inputs here
  });

  // Optional: Initialize any plugins like select2 for better multiselect
  /*
  $(document).ready(function() {
    $('.multiselect').select2({
      width: '100%',
      placeholder: "Select options",
      allowClear: true
    });
  });
  */
</script>
@endsection