#!/bin/bash

# Set proper ownership
chown -R www-data:www-data .

# Set directory permissions
find . -type d -exec chmod 755 {} \;

# Set file permissions
find . -type f -exec chmod 644 {} \;

# Set permissions for storage and cache
chmod -R 775 storage
chmod -R 775 bootstrap/cache

# Make storage and cache directories writable
chown -R www-data:www-data storage
chown -R www-data:www-data bootstrap/cache

# Set permissions for .env file
chmod 600 .env

# Make artisan executable
chmod +x artisan

echo "Permissions have been set successfully!" 