<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                External Agencies
            </h2>

            <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#addExternalAgencyModal">
                <i class="fas fa-plus"></i> Add External Agency
            </button>

        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-6">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

            
            <div class="card shadow-sm border-light rounded mb-4">
                <div class="card-header bg-info text-white text-center">
                    <h5>Filter External Agencies</h5>
                </div>

                <form method="GET" action="<?php echo e(route('external_agencies.index')); ?>" class="p-3">
    <div class="row g-2 align-items-end">
        
        <div class="col-md">
            <label class="form-label">Responsible Name</label>
            <div class="input-group">
                <span class="input-group-text"><i class="bi bi-person"></i></span>
                <input type="text" name="responsible_name" class="form-control" placeholder="Search by responsible name" value="<?php echo e(request('responsible_name')); ?>">
            </div>
        </div>

        
        <div class="col-md">
            <label class="form-label">Company Name</label>
            <div class="input-group">
                <span class="input-group-text"><i class="bi bi-building"></i></span>
                <input type="text" name="company_name" class="form-control" placeholder="Search by company name" value="<?php echo e(request('company_name')); ?>">
            </div>
        </div>

        
        <div class="col-auto">
            <button type="submit" class="btn btn-info mt-2">
                <i class="bi bi-funnel-fill"></i> Filter
            </button>
            <a href="<?php echo e(route('external_agencies.index')); ?>" class="btn btn-outline-secondary mt-2 ms-2">
                <i class="bi bi-x-circle"></i> Clear
            </a>
        </div>
    </div>
</form>

            </div>

            
            <div class="card shadow-sm border-light rounded">
                <div class="card-header bg-light">
                    <h5 class="mb-0">External Agencies List</h5>
                </div>

                <div class="card-body">
    <div class="row">
        <?php $__currentLoopData = $external_agencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-12 mb-4">
                <div class="card shadow rounded shadow-lg">
                    <div class="card-body">
                        <div class="row align-items-start">
                            
                            <div class="col">
                                <div class="row g-3">
                                    
                                    <div class="col-6 col-md-3">
                                        <div class="text-muted small">
                                            <i class="bi bi-person"></i> Responsible Name
                                        </div>
                                        <span id="responsibleNameText<?php echo e($agency->id); ?>"><?php echo e($agency->responsible_name ?? 'N/A'); ?></span>
                                        <input type="text" id="responsibleNameInput<?php echo e($agency->id); ?>" class="form-control" value="<?php echo e($agency->responsible_name ?? 'N/A'); ?>" style="display:none;">
                                    </div>

                                    
                                    <div class="col-6 col-md-3">
                                        <div class="text-muted small">
                                            <i class="bi bi-building"></i> Company
                                        </div>
                                        <span id="companyNameText<?php echo e($agency->id); ?>"><?php echo e($agency->company_name ?? 'N/A'); ?></span>
                                        <input type="text" id="companyNameInput<?php echo e($agency->id); ?>" class="form-control" value="<?php echo e($agency->company_name ?? 'N/A'); ?>" style="display:none;">
                                    </div>

                                    
                                    <div class="col-6 col-md-3">
                                        <div class="text-muted small">
                                            <i class="bi bi-file-earmark-lock"></i> Licence No
                                        </div>
                                        <span id="licenseNumberText<?php echo e($agency->id); ?>"><?php echo e($agency->license_number ?? 'N/A'); ?></span>
                                        <input type="text" id="licenseNumberInput<?php echo e($agency->id); ?>" class="form-control" value="<?php echo e($agency->license_number ?? 'N/A'); ?>" style="display:none;">
                                    </div>

                                    
                                    <div class="col-6 col-md-3">
                                        <div class="text-muted small">
                                            <i class="bi bi-calendar-check"></i> Licence Date
                                        </div>
                                        <span id="licenseDateText<?php echo e($agency->id); ?>"><?php echo e($agency->license_date ?? 'N/A'); ?></span>
                                        <input type="date" id="licenseDateInput<?php echo e($agency->id); ?>" class="form-control" value="<?php echo e($agency->license_date ?? 'N/A'); ?>" style="display:none;">
                                    </div>

                                    
                                    <div class="col-6 col-md-3">
                                        <div class="text-muted small">
                                            <i class="bi bi-envelope"></i> Email
                                        </div>
                                        <span id="emailText<?php echo e($agency->id); ?>"><?php echo e($agency->email); ?></span>
                                        <input type="email" id="emailInput<?php echo e($agency->id); ?>" class="form-control" value="<?php echo e($agency->email); ?>" style="display:none;">
                                    </div>

                                    
                                    <div class="col-6 col-md-3">
                                        <div class="text-muted small">
                                            <i class="bi bi-telephone"></i> Phone
                                        </div>
                                        <span id="phoneText<?php echo e($agency->id); ?>"><?php echo e($agency->phone ?? 'N/A'); ?></span>
                                        <input type="text" id="phoneInput<?php echo e($agency->id); ?>" class="form-control" value="<?php echo e($agency->phone ?? 'N/A'); ?>" style="display:none;">
                                    </div>

                                    
                                    <div class="col-6 col-md-3">
                                        <div class="text-muted small">
                                            <i class="bi bi-house-door"></i> City
                                        </div>
                                        <span id="cityText<?php echo e($agency->id); ?>"><?php echo e($agency->city ?? 'N/A'); ?></span>
                                        <input type="text" id="cityInput<?php echo e($agency->id); ?>" class="form-control" value="<?php echo e($agency->city ?? 'N/A'); ?>" style="display:none;">
                                    </div>

                                    
                                    <div class="col-6 col-md-3">
                                        <div class="text-muted small">
                                            <i class="bi bi-geo-alt"></i> Country
                                        </div>
                                        <span id="countryText<?php echo e($agency->id); ?>"><?php echo e($agency->country ?? 'N/A'); ?></span>
                                        <input type="text" id="countryInput<?php echo e($agency->id); ?>" class="form-control" value="<?php echo e($agency->country ?? 'N/A'); ?>" style="display:none;">
                                    </div>
                                </div>
                            </div>

                            
                            <div class="col-auto text-end">
                                <div class="d-flex flex-column gap-1">
                                <button class="btn btn-sm btn-primary" data-bs-toggle="modal" 
                                        data-bs-target="#editAgencyModal"
                                        data-agency='<?php echo json_encode($agency, 15, 512) ?>'>
                                    <i class="fas fa-edit"></i> Edit
                                </button>
                                    <button type="button" class="btn btn-danger btn-sm delete-agency" 
                                            data-agency-id="<?php echo e($agency->id); ?>"
                                            data-agency-name="<?php echo e($agency->company_name); ?>"
                                            data-delete-url="<?php echo e(route('external_agencies.destroy', $agency->id)); ?>">
                                        <i class="fas fa-trash"></i> Delete
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <?php if($external_agencies->isEmpty()): ?>
            <div class="col-12 text-center text-muted">
                <p>No external agencies found.</p>
            </div>
        <?php endif; ?>
    </div>

    
    <div class="d-flex justify-content-center mt-3">
        <?php echo e($external_agencies->appends(request()->query())->links('pagination::bootstrap-4')); ?>

    </div>
</div>


            </div>
        </div>
    </div>

    <!-- Add External Agency Modal -->
    <?php echo $__env->make('external_agencies.create', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Edit External Agency Modal -->
    <?php echo $__env->make('external_agencies.edit-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.27/dist/sweetalert2.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.27/dist/sweetalert2.min.js"></script>

    <script>
        // Toast configuration for success messages
        const Toast = Swal.mixin({
            toast: true,
            position: 'center',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            width: 'auto',
            padding: '0.5em',
            customClass: {
                popup: 'colored-toast'
            },
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        });

        // Error alert configuration
        const ErrorAlert = Swal.mixin({
            toast: true,
            position: 'center',
            showConfirmButton: true,
            confirmButtonColor: '#3085d6',
            confirmButtonText: 'OK',
            icon: 'error',
            width: 'auto',
            padding: '0.5em',
            customClass: {
                popup: 'colored-toast'
            }
        });

        // Add custom styles for smaller popups
        const style = document.createElement('style');
        style.textContent = `
            .colored-toast {
                font-size: 0.9em !important;
                min-width: 200px !important;
                max-width: 400px !important;
            }
            .colored-toast .swal2-title {
                font-size: 1.1em !important;
                margin: 0.5em !important;
            }
            .colored-toast .swal2-html-container {
                font-size: 0.9em !important;
                margin: 0.5em !important;
            }
            .colored-toast .swal2-confirm {
                padding: 0.3em 1em !important;
                font-size: 0.9em !important;
            }
        `;
        document.head.appendChild(style);

        // Handle Delete Action
        document.querySelectorAll('.delete-agency').forEach(button => {
            button.addEventListener('click', function() {
                const agencyId = this.dataset.agencyId;
                const agencyName = this.dataset.agencyName;
                const deleteUrl = this.dataset.deleteUrl;
                
                Swal.fire({
                    title: 'Are you sure?',
                    text: `Do you want to delete ${agencyName}?`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Yes, delete it!',
                    width: 'auto',
                    padding: '0.5em',
                    customClass: {
                        popup: 'colored-toast'
                    }
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Create a form and submit it
                        const form = document.createElement('form');
                        form.method = 'POST';
                        form.action = deleteUrl;

                        // Add CSRF token
                        const csrfInput = document.createElement('input');
                        csrfInput.type = 'hidden';
                        csrfInput.name = '_token';
                        csrfInput.value = document.querySelector('meta[name="csrf-token"]').content;
                        form.appendChild(csrfInput);

                        // Add method spoofing for DELETE
                        const methodInput = document.createElement('input');
                        methodInput.type = 'hidden';
                        methodInput.name = '_method';
                        methodInput.value = 'DELETE';
                        form.appendChild(methodInput);

                        // Add form to document and submit
                        document.body.appendChild(form);
                        form.submit();
                    }
                });
            });
        });

        // Handle Edit Form Submit
        const editForm = document.querySelector('#editAgencyForm');
        if (editForm) {
            editForm.addEventListener('submit', function(e) {
                e.preventDefault();
                const formData = new FormData(this);
                
                fetch(this.action, {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        Toast.fire({
                            icon: 'success',
                            title: data.message
                        }).then(() => {
                            window.location.reload();
                        });
                    }
                })
                .catch(error => {
                    ErrorAlert.fire({
                        title: 'Error',
                        text: 'An error occurred while updating the agency'
                    });
                });
            });
        }

        // Handle Success Messages
        <?php if(session('success')): ?>
            Toast.fire({
                icon: 'success',
                title: '<?php echo e(session('success')); ?>'
            });
        <?php endif; ?>

        // Handle Error Messages
        <?php if(session('error')): ?>
            ErrorAlert.fire({
                title: 'Error',
                text: '<?php echo e(session('error')); ?>'
            });
        <?php endif; ?>
    </script>

    <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /home/frankie_254/HIRESTREAM-APP/resources/views/external_agencies/index.blade.php ENDPATH**/ ?>