<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="mb-0">Create Payment Voucher</h4>
        <a href="<?php echo e(route('vouchers.index')); ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back to List
        </a>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="<?php echo e(route('vouchers.store')); ?>" method="POST" id="voucherForm">
                <?php echo csrf_field(); ?>

                <?php if($selectedWorker): ?>
                <input type="hidden" name="preselected_worker_id" value="<?php echo e($selectedWorker->id); ?>">
                <?php endif; ?>

                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="sub_agent_id" class="form-label">Sub Agent *</label>
                            <select name="sub_agent_id" id="sub_agent_id" class="form-select <?php $__errorArgs = ['sub_agent_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required
                                    onchange="filterWorkers(this.value)">
                                <option value="">Select Sub Agent</option>
                                <?php $__currentLoopData = $subAgents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subAgent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($subAgent->id); ?>" 
                                        data-commission-rate="<?php echo e($subAgent->commission_rate); ?>"
                                        <?php echo e(old('sub_agent_id') == $subAgent->id ? 'selected' : ''); ?>

                                        <?php echo e($selectedSubAgentId == $subAgent->id ? 'selected' : ''); ?>>
                                        <?php echo e($subAgent->name); ?> (<?php echo e($subAgent->commission_rate); ?>%)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['sub_agent_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="voucher_type" class="form-label">Voucher Type *</label>
                            <select name="voucher_type" id="voucher_type" class="form-select <?php $__errorArgs = ['voucher_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <option value="">Select Type</option>
                                <option value="advance" <?php echo e(old('voucher_type') == 'advance' ? 'selected' : ''); ?>>Advance</option>
                                <option value="final" <?php echo e(old('voucher_type') == 'final' ? 'selected' : ''); ?>>Final</option>
                            </select>
                            <?php $__errorArgs = ['voucher_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <!-- Available Workers Table -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">Available Travelled Workers</h5>
                    </div>
                    <div class="card-body">
                        <?php if($workers->isEmpty()): ?>
                            <div class="alert alert-warning">
                                No travelled workers found
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Passport</th>
                                            <th>Sub Agent</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $workers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $worker): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($worker->surname); ?>, <?php echo e($worker->name); ?></td>
                                            <td><?php echo e($worker->passport_number); ?></td>
                                            <td><?php echo e($worker->subAgent->name ?? 'N/A'); ?></td>
                                            <td>
                                                <span class="badge bg-success">Travelled</span>
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-sm btn-primary add-worker-btn" 
                                                        data-worker-id="<?php echo e($worker->id); ?>"
                                                        data-worker-name="<?php echo e($worker->surname); ?>, <?php echo e($worker->name); ?> (<?php echo e($worker->passport_number); ?>)"
                                                        data-sub-agent-id="<?php echo e($worker->sub_agent_id); ?>"
                                                        data-sub-agent-name="<?php echo e($worker->subAgent->name ?? ''); ?>">
                                                    <i class="fas fa-plus"></i> Add to Voucher
                                                </button>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Workers in Voucher Section -->
                <div class="card mb-4">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Workers in Voucher</h5>
                        <div>
                            <span class="me-2">Total Amount: <span id="totalAmount">0.00</span></span>
                            <button type="button" class="btn btn-sm btn-primary" id="addWorker">
                                <i class="fas fa-plus"></i> Add Worker
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div id="workersContainer">
                            <!-- Worker rows will be added here -->
                        </div>
                        <?php $__errorArgs = ['workers'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="form-group mb-4">
                    <label for="notes" class="form-label">Notes</label>
                    <textarea name="notes" id="notes" class="form-control <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="3"><?php echo e(old('notes')); ?></textarea>
                    <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Create Voucher
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const workersContainer = document.getElementById('workersContainer');
        const addWorkerBtn = document.getElementById('addWorker');
        const subAgentSelect = document.getElementById('sub_agent_id');
        const totalAmountElement = document.getElementById('totalAmount');
        let workerCount = 0;
        let totalAmount = 0;
        
        // Store workers data and commission rates
        const allWorkers = <?php echo json_encode($workers->map(function($worker) {
            return [
                'id' => $worker->id,
                'name' => $worker->name,
                'surname' => $worker->surname,
                'passport_number' => $worker->passport_number,
                'sub_agent_id' => $worker->sub_agent_id,
                'sub_agent_name' => $worker->subAgent->name ?? null,
                'commission_rate' => $worker->subAgent->commission_rate ?? 0
            ];
        })); ?>;

        const subAgents = <?php echo json_encode($subAgents->map(function($agent) {
            return [
                'id' => $agent->id,
                'name' => $agent->name,
                'commission_rate' => $agent->commission_rate
            ];
        })); ?>;

        // Function to calculate amount based on commission rate
        function calculateAmount(commissionRate) {
            // Your calculation logic here
            // For example: base amount * commission rate
            return (1000 * (commissionRate / 100)).toFixed(2);
        }

        // Function to update total amount
        function updateTotalAmount() {
            let total = 0;
            document.querySelectorAll('input[name^="workers["][name$="[amount]"]').forEach(input => {
                total += parseFloat(input.value) || 0;
            });
            totalAmount = total;
            totalAmountElement.textContent = total.toFixed(2);
        }

        // Function to create a new worker row
        function addWorkerRow(workerId = null, subAgentId = null) {
            const workerRow = document.createElement('div');
            workerRow.className = 'worker-row row mb-3';
            
            let optionsHtml = '<option value="">Select Worker</option>';
            let selectedSubAgentId = subAgentId || subAgentSelect.value;
            let commissionRate = 0;
            
            // Find commission rate for selected sub-agent
            const selectedSubAgent = subAgents.find(agent => agent.id == selectedSubAgentId);
            if (selectedSubAgent) {
                commissionRate = selectedSubAgent.commission_rate;
            }
            
            // Filter workers by selected sub-agent if one is selected
            allWorkers.forEach(function(worker) {
                if (!selectedSubAgentId || worker.sub_agent_id == selectedSubAgentId) {
                    const selected = workerId === worker.id ? 'selected' : '';
                    optionsHtml += `
                        <option value="${worker.id}" 
                                data-sub-agent-id="${worker.sub_agent_id}"
                                ${selected}>
                            ${worker.surname}, ${worker.name} (${worker.passport_number})
                        </option>
                    `;
                }
            });

            workerRow.innerHTML = `
                <div class="col-md-5">
                    <select name="workers[${workerCount}][id]" class="form-select worker-select" required>
                        ${optionsHtml}
                    </select>
                </div>
                <div class="col-md-5">
                    <input type="number" name="workers[${workerCount}][amount]" 
                           class="form-control worker-amount" placeholder="Amount" 
                           step="0.01" min="0" value="${calculateAmount(commissionRate)}" required>
                </div>
                <div class="col-md-2">
                    <button type="button" class="btn btn-danger btn-sm remove-worker">
                        <i class="fas fa-times"></i> Remove
                    </button>
                </div>
            `;

            workersContainer.appendChild(workerRow);

            // Add event listeners
            workerRow.querySelector('.remove-worker').addEventListener('click', function() {
                workerRow.remove();
                updateTotalAmount();
            });

            workerRow.querySelector('.worker-select').addEventListener('change', function() {
                const selectedOption = this.options[this.selectedIndex];
                const workerSubAgentId = selectedOption.dataset.subAgentId;
                const workerSubAgent = subAgents.find(agent => agent.id == workerSubAgentId);
                
                if (workerSubAgent) {
                    const amountInput = workerRow.querySelector('.worker-amount');
                    amountInput.value = calculateAmount(workerSubAgent.commission_rate);
                    updateTotalAmount();
                }
            });

            workerRow.querySelector('.worker-amount').addEventListener('change', updateTotalAmount);

            // If workerId was provided, select it
            if (workerId) {
                workerRow.querySelector('.worker-select').value = workerId;
                // Trigger change event to update amount
                workerRow.querySelector('.worker-select').dispatchEvent(new Event('change'));
            }

            workerCount++;
            updateTotalAmount();
        }

        // Handle add worker buttons from table
        document.addEventListener('click', function(e) {
            if (e.target.closest('.add-worker-btn')) {
                const button = e.target.closest('.add-worker-btn');
                const workerId = button.dataset.workerId;
                const subAgentId = button.dataset.subAgentId;
                
                // Check if worker already added
                const existingSelects = document.querySelectorAll('.worker-select');
                let alreadyAdded = false;
                
                existingSelects.forEach(select => {
                    if (select.value === workerId) {
                        alreadyAdded = true;
                    }
                });
                
                if (alreadyAdded) {
                    alert('This worker is already in the voucher');
                    return;
                }
                
                // Add new worker row
                addWorkerRow(workerId, subAgentId);
                
                // Scroll to workers container
                document.getElementById('workersContainer').scrollIntoView({
                    behavior: 'smooth'
                });
            }
        });

        // Add worker row when clicking the add button
        addWorkerBtn.addEventListener('click', function() {
            addWorkerRow();
        });

        // Update amounts when sub-agent changes
        subAgentSelect.addEventListener('change', function() {
            const commissionRate = this.options[this.selectedIndex].dataset.commissionRate || 0;
            document.querySelectorAll('.worker-amount').forEach(input => {
                input.value = calculateAmount(commissionRate);
            });
            updateTotalAmount();
        });

        // Add initial worker row if preselected
        if (<?php echo e($selectedWorker ? 'true' : 'false'); ?>) {
            addWorkerRow(<?php echo e($selectedWorker ? $selectedWorker->id : 'null'); ?>);
        }

        // Initialize total amount
        updateTotalAmount();
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.vouchers', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/frankie_254/HIRESTREAM-APP/resources/views/vouchers/create.blade.php ENDPATH**/ ?>